/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcePolicyResponse extends MpaResponse implements
        ToCopyableBuilder<GetResourcePolicyResponse.Builder, GetResourcePolicyResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GetResourcePolicyResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(GetResourcePolicyResponse::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> POLICY_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyVersionArn").getter(getter(GetResourcePolicyResponse::policyVersionArn))
            .setter(setter(Builder::policyVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionArn").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(GetResourcePolicyResponse::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(GetResourcePolicyResponse::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            POLICY_TYPE_FIELD, POLICY_VERSION_ARN_FIELD, POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String policyType;

    private final String policyVersionArn;

    private final String policyName;

    private final String policyDocument;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.policyType = builder.policyType;
        this.policyVersionArn = builder.policyVersionArn;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the policy version.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the policy version.
     */
    public final String policyVersionArn() {
        return policyVersionArn;
    }

    /**
     * <p>
     * Name of the policy.
     * </p>
     * 
     * @return Name of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Document that contains the contents for the policy.
     * </p>
     * 
     * @return Document that contains the contents for the policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(policyVersionArn(), other.policyVersionArn())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcePolicyResponse").add("ResourceArn", resourceArn())
                .add("PolicyType", policyTypeAsString()).add("PolicyVersionArn", policyVersionArn())
                .add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "PolicyVersionArn":
            return Optional.ofNullable(clazz.cast(policyVersionArn()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("PolicyVersionArn", POLICY_VERSION_ARN_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcePolicyResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) for the resource.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of policy
         * </p>
         * 
         * @param policyType
         *        The type of policy
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy
         * </p>
         * 
         * @param policyType
         *        The type of policy
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the policy version.
         * </p>
         * 
         * @param policyVersionArn
         *        Amazon Resource Name (ARN) for the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionArn(String policyVersionArn);

        /**
         * <p>
         * Name of the policy.
         * </p>
         * 
         * @param policyName
         *        Name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Document that contains the contents for the policy.
         * </p>
         * 
         * @param policyDocument
         *        Document that contains the contents for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private String resourceArn;

        private String policyType;

        private String policyVersionArn;

        private String policyName;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            resourceArn(model.resourceArn);
            policyType(model.policyType);
            policyVersionArn(model.policyVersionArn);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyVersionArn() {
            return policyVersionArn;
        }

        public final void setPolicyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
        }

        @Override
        public final Builder policyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
