/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.PolicyStatus;
import software.amazon.awssdk.services.mpa.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PolicyVersion.getter(PolicyVersion::arn)).setter(PolicyVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(PolicyVersion.getter(PolicyVersion::policyArn)).setter(PolicyVersion.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionId").getter(PolicyVersion.getter(PolicyVersion::versionId)).setter(PolicyVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(PolicyVersion.getter(PolicyVersion::policyTypeAsString)).setter(PolicyVersion.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(PolicyVersion.getter(PolicyVersion::isDefault)).setter(PolicyVersion.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PolicyVersion.getter(PolicyVersion::name)).setter(PolicyVersion.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PolicyVersion.getter(PolicyVersion::statusAsString)).setter(PolicyVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(PolicyVersion.getter(PolicyVersion::creationTime)).setter(PolicyVersion.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(PolicyVersion.getter(PolicyVersion::lastUpdatedTime)).setter(PolicyVersion.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Document").getter(PolicyVersion.getter(PolicyVersion::document)).setter(PolicyVersion.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, POLICY_ARN_FIELD, VERSION_ID_FIELD, POLICY_TYPE_FIELD, IS_DEFAULT_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String policyArn;
    private final Integer versionId;
    private final String policyType;
    private final Boolean isDefault;
    private final String name;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String document;

    private PolicyVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.policyArn = builder.policyArn;
        this.versionId = builder.versionId;
        this.policyType = builder.policyType;
        this.isDefault = builder.isDefault;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.document = builder.document;
    }

    public final String arn() {
        return this.arn;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final Integer versionId() {
        return this.versionId;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String name() {
        return this.name;
    }

    public final PolicyStatus status() {
        return PolicyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyVersion").add("Arn", (Object)this.arn()).add("PolicyArn", (Object)this.policyArn()).add("VersionId", (Object)this.versionId()).add("PolicyType", (Object)this.policyTypeAsString()).add("IsDefault", (Object)this.isDefault()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Document", (Object)(this.document() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Document", DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyVersion, T> g) {
        return obj -> g.apply((PolicyVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String policyArn;
        private Integer versionId;
        private String policyType;
        private Boolean isDefault;
        private String name;
        private String status;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            this.arn(model.arn);
            this.policyArn(model.policyArn);
            this.versionId(model.versionId);
            this.policyType(model.policyType);
            this.isDefault(model.isDefault);
            this.name(model.name);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.document(model.document);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Integer getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getDocument() {
            return this.document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public PolicyVersion build() {
            return new PolicyVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyVersion> {
        public Builder arn(String var1);

        public Builder policyArn(String var1);

        public Builder versionId(Integer var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder isDefault(Boolean var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(PolicyStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder document(String var1);
    }
}

