/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaAsyncClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponseApprovalTeam;

public class ListApprovalTeamsPublisher
implements SdkPublisher<ListApprovalTeamsResponse> {
    private final MpaAsyncClient client;
    private final ListApprovalTeamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApprovalTeamsPublisher(MpaAsyncClient client, ListApprovalTeamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApprovalTeamsPublisher(MpaAsyncClient client, ListApprovalTeamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApprovalTeamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApprovalTeamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListApprovalTeamsResponseApprovalTeam> approvalTeams() {
        Function<ListApprovalTeamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.approvalTeams() != null) {
                return response.approvalTeams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApprovalTeamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApprovalTeamsResponseFetcher
    implements AsyncPageFetcher<ListApprovalTeamsResponse> {
        private ListApprovalTeamsResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovalTeamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApprovalTeamsResponse> nextPage(ListApprovalTeamsResponse previousPage) {
            if (previousPage == null) {
                return ListApprovalTeamsPublisher.this.client.listApprovalTeams(ListApprovalTeamsPublisher.this.firstRequest);
            }
            return ListApprovalTeamsPublisher.this.client.listApprovalTeams((ListApprovalTeamsRequest)((Object)ListApprovalTeamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

