/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mobile.model.MobileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectRequest
extends MobileRequest
implements ToCopyableBuilder<Builder, CreateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateProjectRequest.getter(CreateProjectRequest::name)).setter(CreateProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(CreateProjectRequest.getter(CreateProjectRequest::region)).setter(CreateProjectRequest.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("region").build()}).build();
    private static final SdkField<SdkBytes> CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("contents").getter(CreateProjectRequest.getter(CreateProjectRequest::contents)).setter(CreateProjectRequest.setter(Builder::contents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotId").getter(CreateProjectRequest.getter(CreateProjectRequest::snapshotId)).setter(CreateProjectRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("snapshotId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGION_FIELD, CONTENTS_FIELD, SNAPSHOT_ID_FIELD));
    private final String name;
    private final String region;
    private final SdkBytes contents;
    private final String snapshotId;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.region = builder.region;
        this.contents = builder.contents;
        this.snapshotId = builder.snapshotId;
    }

    public final String name() {
        return this.name;
    }

    public final String region() {
        return this.region;
    }

    public final SdkBytes contents() {
        return this.contents;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.contents());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.contents(), other.contents()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProjectRequest").add("Name", (Object)this.name()).add("Region", (Object)this.region()).add("Contents", (Object)this.contents()).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "contents": {
                return Optional.ofNullable(clazz.cast(this.contents()));
            }
            case "snapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileRequest.BuilderImpl
    implements Builder {
        private String name;
        private String region;
        private SdkBytes contents;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            this.name(model.name);
            this.region(model.region);
            this.contents(model.contents);
            this.snapshotId(model.snapshotId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final ByteBuffer getContents() {
            return this.contents == null ? null : this.contents.asByteBuffer();
        }

        @Override
        public final Builder contents(SdkBytes contents) {
            this.contents = StandardMemberCopier.copy((SdkBytes)contents);
            return this;
        }

        public final void setContents(ByteBuffer contents) {
            this.contents(contents == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)contents));
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectRequest> {
        public Builder name(String var1);

        public Builder region(String var1);

        public Builder contents(SdkBytes var1);

        public Builder snapshotId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

