/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.AuthType;
import software.amazon.awssdk.services.migrationhubstrategy.model.OSType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPAddressBasedRemoteInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPAddressBasedRemoteInfo> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(IPAddressBasedRemoteInfo.getter(IPAddressBasedRemoteInfo::authTypeAsString)).setter(IPAddressBasedRemoteInfo.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> IP_ADDRESS_CONFIGURATION_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressConfigurationTimeStamp").getter(IPAddressBasedRemoteInfo.getter(IPAddressBasedRemoteInfo::ipAddressConfigurationTimeStamp)).setter(IPAddressBasedRemoteInfo.setter(Builder::ipAddressConfigurationTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressConfigurationTimeStamp").build()}).build();
    private static final SdkField<String> OS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osType").getter(IPAddressBasedRemoteInfo.getter(IPAddressBasedRemoteInfo::osTypeAsString)).setter(IPAddressBasedRemoteInfo.setter(Builder::osType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD, IP_ADDRESS_CONFIGURATION_TIME_STAMP_FIELD, OS_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authType;
    private final String ipAddressConfigurationTimeStamp;
    private final String osType;

    private IPAddressBasedRemoteInfo(BuilderImpl builder) {
        this.authType = builder.authType;
        this.ipAddressConfigurationTimeStamp = builder.ipAddressConfigurationTimeStamp;
        this.osType = builder.osType;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String ipAddressConfigurationTimeStamp() {
        return this.ipAddressConfigurationTimeStamp;
    }

    public final OSType osType() {
        return OSType.fromValue(this.osType);
    }

    public final String osTypeAsString() {
        return this.osType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressConfigurationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.osTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPAddressBasedRemoteInfo)) {
            return false;
        }
        IPAddressBasedRemoteInfo other = (IPAddressBasedRemoteInfo)obj;
        return Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.ipAddressConfigurationTimeStamp(), other.ipAddressConfigurationTimeStamp()) && Objects.equals(this.osTypeAsString(), other.osTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IPAddressBasedRemoteInfo").add("AuthType", (Object)this.authTypeAsString()).add("IpAddressConfigurationTimeStamp", (Object)this.ipAddressConfigurationTimeStamp()).add("OsType", (Object)this.osTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "ipAddressConfigurationTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.ipAddressConfigurationTimeStamp()));
            }
            case "osType": {
                return Optional.ofNullable(clazz.cast(this.osTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPAddressBasedRemoteInfo, T> g) {
        return obj -> g.apply((IPAddressBasedRemoteInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authType;
        private String ipAddressConfigurationTimeStamp;
        private String osType;

        private BuilderImpl() {
        }

        private BuilderImpl(IPAddressBasedRemoteInfo model) {
            this.authType(model.authType);
            this.ipAddressConfigurationTimeStamp(model.ipAddressConfigurationTimeStamp);
            this.osType(model.osType);
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getIpAddressConfigurationTimeStamp() {
            return this.ipAddressConfigurationTimeStamp;
        }

        public final void setIpAddressConfigurationTimeStamp(String ipAddressConfigurationTimeStamp) {
            this.ipAddressConfigurationTimeStamp = ipAddressConfigurationTimeStamp;
        }

        @Override
        public final Builder ipAddressConfigurationTimeStamp(String ipAddressConfigurationTimeStamp) {
            this.ipAddressConfigurationTimeStamp = ipAddressConfigurationTimeStamp;
            return this;
        }

        public final String getOsType() {
            return this.osType;
        }

        public final void setOsType(String osType) {
            this.osType = osType;
        }

        @Override
        public final Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public final Builder osType(OSType osType) {
            this.osType(osType == null ? null : osType.toString());
            return this;
        }

        public IPAddressBasedRemoteInfo build() {
            return new IPAddressBasedRemoteInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPAddressBasedRemoteInfo> {
        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder ipAddressConfigurationTimeStamp(String var1);

        public Builder osType(String var1);

        public Builder osType(OSType var1);
    }
}

