/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMigrationTaskUpdatesResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, ListMigrationTaskUpdatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMigrationTaskUpdatesResponse.getter(ListMigrationTaskUpdatesResponse::nextToken)).setter(ListMigrationTaskUpdatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MigrationTaskUpdate>> MIGRATION_TASK_UPDATE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MigrationTaskUpdateList").getter(ListMigrationTaskUpdatesResponse.getter(ListMigrationTaskUpdatesResponse::migrationTaskUpdateList)).setter(ListMigrationTaskUpdatesResponse.setter(Builder::migrationTaskUpdateList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskUpdateList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MigrationTaskUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MIGRATION_TASK_UPDATE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMigrationTaskUpdatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MigrationTaskUpdate> migrationTaskUpdateList;

    private ListMigrationTaskUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.migrationTaskUpdateList = builder.migrationTaskUpdateList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMigrationTaskUpdateList() {
        return this.migrationTaskUpdateList != null && !(this.migrationTaskUpdateList instanceof SdkAutoConstructList);
    }

    public final List<MigrationTaskUpdate> migrationTaskUpdateList() {
        return this.migrationTaskUpdateList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMigrationTaskUpdateList() ? this.migrationTaskUpdateList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMigrationTaskUpdatesResponse)) {
            return false;
        }
        ListMigrationTaskUpdatesResponse other = (ListMigrationTaskUpdatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMigrationTaskUpdateList() == other.hasMigrationTaskUpdateList() && Objects.equals(this.migrationTaskUpdateList(), other.migrationTaskUpdateList());
    }

    public final String toString() {
        return ToString.builder((String)"ListMigrationTaskUpdatesResponse").add("NextToken", (Object)this.nextToken()).add("MigrationTaskUpdateList", this.hasMigrationTaskUpdateList() ? this.migrationTaskUpdateList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MigrationTaskUpdateList": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskUpdateList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MigrationTaskUpdateList", MIGRATION_TASK_UPDATE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMigrationTaskUpdatesResponse, T> g) {
        return obj -> g.apply((ListMigrationTaskUpdatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MigrationTaskUpdate> migrationTaskUpdateList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMigrationTaskUpdatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.migrationTaskUpdateList(model.migrationTaskUpdateList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MigrationTaskUpdate.Builder> getMigrationTaskUpdateList() {
            List<MigrationTaskUpdate.Builder> result = MigrationTaskUpdateListCopier.copyToBuilder(this.migrationTaskUpdateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationTaskUpdateList(Collection<MigrationTaskUpdate.BuilderImpl> migrationTaskUpdateList) {
            this.migrationTaskUpdateList = MigrationTaskUpdateListCopier.copyFromBuilder(migrationTaskUpdateList);
        }

        @Override
        public final Builder migrationTaskUpdateList(Collection<MigrationTaskUpdate> migrationTaskUpdateList) {
            this.migrationTaskUpdateList = MigrationTaskUpdateListCopier.copy(migrationTaskUpdateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskUpdateList(MigrationTaskUpdate ... migrationTaskUpdateList) {
            this.migrationTaskUpdateList(Arrays.asList(migrationTaskUpdateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskUpdateList(Consumer<MigrationTaskUpdate.Builder> ... migrationTaskUpdateList) {
            this.migrationTaskUpdateList(Stream.of(migrationTaskUpdateList).map(c -> (MigrationTaskUpdate)((MigrationTaskUpdate.Builder)MigrationTaskUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMigrationTaskUpdatesResponse build() {
            return new ListMigrationTaskUpdatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMigrationTaskUpdatesResponse> {
        public Builder nextToken(String var1);

        public Builder migrationTaskUpdateList(Collection<MigrationTaskUpdate> var1);

        public Builder migrationTaskUpdateList(MigrationTaskUpdate ... var1);

        public Builder migrationTaskUpdateList(Consumer<MigrationTaskUpdate.Builder> ... var1);
    }
}

