/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ImportTask;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;

public class ListImportsIterable
implements SdkIterable<ListImportsResponse> {
    private final MgnClient client;
    private final ListImportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportsIterable(MgnClient client, ListImportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public Iterator<ListImportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportTask> items() {
        Function<ListImportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportsResponseFetcher
    implements SyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportsResponse nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsIterable.this.client.listImports(ListImportsIterable.this.firstRequest);
            }
            return ListImportsIterable.this.client.listImports((ListImportsRequest)((Object)ListImportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

