/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.RegionalCluster;
import software.amazon.awssdk.services.memorydb.model.RegionalClusterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiRegionCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiRegionCluster> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionClusterName").getter(MultiRegionCluster.getter(MultiRegionCluster::multiRegionClusterName)).setter(MultiRegionCluster.setter(Builder::multiRegionClusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MultiRegionCluster.getter(MultiRegionCluster::description)).setter(MultiRegionCluster.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MultiRegionCluster.getter(MultiRegionCluster::status)).setter(MultiRegionCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(MultiRegionCluster.getter(MultiRegionCluster::nodeType)).setter(MultiRegionCluster.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(MultiRegionCluster.getter(MultiRegionCluster::engine)).setter(MultiRegionCluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(MultiRegionCluster.getter(MultiRegionCluster::engineVersion)).setter(MultiRegionCluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfShards").getter(MultiRegionCluster.getter(MultiRegionCluster::numberOfShards)).setter(MultiRegionCluster.setter(Builder::numberOfShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfShards").build()}).build();
    private static final SdkField<List<RegionalCluster>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Clusters").getter(MultiRegionCluster.getter(MultiRegionCluster::clusters)).setter(MultiRegionCluster.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionalCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionParameterGroupName").getter(MultiRegionCluster.getter(MultiRegionCluster::multiRegionParameterGroupName)).setter(MultiRegionCluster.setter(Builder::multiRegionParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName").build()}).build();
    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TLSEnabled").getter(MultiRegionCluster.getter(MultiRegionCluster::tlsEnabled)).setter(MultiRegionCluster.setter(Builder::tlsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(MultiRegionCluster.getter(MultiRegionCluster::arn)).setter(MultiRegionCluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_CLUSTER_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, NUMBER_OF_SHARDS_FIELD, CLUSTERS_FIELD, MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, TLS_ENABLED_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiRegionCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String multiRegionClusterName;
    private final String description;
    private final String status;
    private final String nodeType;
    private final String engine;
    private final String engineVersion;
    private final Integer numberOfShards;
    private final List<RegionalCluster> clusters;
    private final String multiRegionParameterGroupName;
    private final Boolean tlsEnabled;
    private final String arn;

    private MultiRegionCluster(BuilderImpl builder) {
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.description = builder.description;
        this.status = builder.status;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.numberOfShards = builder.numberOfShards;
        this.clusters = builder.clusters;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.tlsEnabled = builder.tlsEnabled;
        this.arn = builder.arn;
    }

    public final String multiRegionClusterName() {
        return this.multiRegionClusterName;
    }

    public final String description() {
        return this.description;
    }

    public final String status() {
        return this.status;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer numberOfShards() {
        return this.numberOfShards;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<RegionalCluster> clusters() {
        return this.clusters;
    }

    public final String multiRegionParameterGroupName() {
        return this.multiRegionParameterGroupName;
    }

    public final Boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionCluster)) {
            return false;
        }
        MultiRegionCluster other = (MultiRegionCluster)obj;
        return Objects.equals(this.multiRegionClusterName(), other.multiRegionClusterName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.numberOfShards(), other.numberOfShards()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.multiRegionParameterGroupName(), other.multiRegionParameterGroupName()) && Objects.equals(this.tlsEnabled(), other.tlsEnabled()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"MultiRegionCluster").add("MultiRegionClusterName", (Object)this.multiRegionClusterName()).add("Description", (Object)this.description()).add("Status", (Object)this.status()).add("NodeType", (Object)this.nodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("NumberOfShards", (Object)this.numberOfShards()).add("Clusters", this.hasClusters() ? this.clusters() : null).add("MultiRegionParameterGroupName", (Object)this.multiRegionParameterGroupName()).add("TLSEnabled", (Object)this.tlsEnabled()).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiRegionClusterName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusterName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "NumberOfShards": {
                return Optional.ofNullable(clazz.cast(this.numberOfShards()));
            }
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "MultiRegionParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameterGroupName()));
            }
            case "TLSEnabled": {
                return Optional.ofNullable(clazz.cast(this.tlsEnabled()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NumberOfShards", NUMBER_OF_SHARDS_FIELD);
        map.put("Clusters", CLUSTERS_FIELD);
        map.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
        map.put("TLSEnabled", TLS_ENABLED_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionCluster, T> g) {
        return obj -> g.apply((MultiRegionCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multiRegionClusterName;
        private String description;
        private String status;
        private String nodeType;
        private String engine;
        private String engineVersion;
        private Integer numberOfShards;
        private List<RegionalCluster> clusters = DefaultSdkAutoConstructList.getInstance();
        private String multiRegionParameterGroupName;
        private Boolean tlsEnabled;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionCluster model) {
            this.multiRegionClusterName(model.multiRegionClusterName);
            this.description(model.description);
            this.status(model.status);
            this.nodeType(model.nodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.numberOfShards(model.numberOfShards);
            this.clusters(model.clusters);
            this.multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            this.tlsEnabled(model.tlsEnabled);
            this.arn(model.arn);
        }

        public final String getMultiRegionClusterName() {
            return this.multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public final void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        @Override
        public final Builder numberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
            return this;
        }

        public final List<RegionalCluster.Builder> getClusters() {
            List<RegionalCluster.Builder> result = RegionalClusterListCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<RegionalCluster.BuilderImpl> clusters) {
            this.clusters = RegionalClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<RegionalCluster> clusters) {
            this.clusters = RegionalClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(RegionalCluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<RegionalCluster.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (RegionalCluster)((RegionalCluster.Builder)RegionalCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return this.multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return this.tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public MultiRegionCluster build() {
            return new MultiRegionCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiRegionCluster> {
        public Builder multiRegionClusterName(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder nodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder numberOfShards(Integer var1);

        public Builder clusters(Collection<RegionalCluster> var1);

        public Builder clusters(RegionalCluster ... var1);

        public Builder clusters(Consumer<RegionalCluster.Builder> ... var1);

        public Builder multiRegionParameterGroupName(String var1);

        public Builder tlsEnabled(Boolean var1);

        public Builder arn(String var1);
    }
}

