/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.Cluster;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;

public class DescribeClustersIterable
implements SdkIterable<DescribeClustersResponse> {
    private final MemoryDbClient client;
    private final DescribeClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClustersIterable(MemoryDbClient client, DescribeClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public Iterator<DescribeClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Cluster> clusters() {
        Function<DescribeClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClustersResponseFetcher
    implements SyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClustersResponse nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersIterable.this.client.describeClusters(DescribeClustersIterable.this.firstRequest);
            }
            return DescribeClustersIterable.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

