/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersResponse;
import software.amazon.awssdk.services.memorydb.model.MultiRegionCluster;

public class DescribeMultiRegionClustersIterable
implements SdkIterable<DescribeMultiRegionClustersResponse> {
    private final MemoryDbClient client;
    private final DescribeMultiRegionClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMultiRegionClustersIterable(MemoryDbClient client, DescribeMultiRegionClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMultiRegionClustersResponseFetcher();
    }

    public Iterator<DescribeMultiRegionClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultiRegionCluster> multiRegionClusters() {
        Function<DescribeMultiRegionClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiRegionClusters() != null) {
                return response.multiRegionClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMultiRegionClustersResponseFetcher
    implements SyncPageFetcher<DescribeMultiRegionClustersResponse> {
        private DescribeMultiRegionClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMultiRegionClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMultiRegionClustersResponse nextPage(DescribeMultiRegionClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeMultiRegionClustersIterable.this.client.describeMultiRegionClusters(DescribeMultiRegionClustersIterable.this.firstRequest);
            }
            return DescribeMultiRegionClustersIterable.this.client.describeMultiRegionClusters((DescribeMultiRegionClustersRequest)((Object)DescribeMultiRegionClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

