/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMultiRegionClusterRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, UpdateMultiRegionClusterRequest> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionClusterName").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::multiRegionClusterName)).setter(UpdateMultiRegionClusterRequest.setter(Builder::multiRegionClusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::nodeType)).setter(UpdateMultiRegionClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::description)).setter(UpdateMultiRegionClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::engineVersion)).setter(UpdateMultiRegionClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<ShardConfigurationRequest> SHARD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShardConfiguration").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::shardConfiguration)).setter(UpdateMultiRegionClusterRequest.setter(Builder::shardConfiguration)).constructor(ShardConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardConfiguration").build()}).build();
    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionParameterGroupName").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::multiRegionParameterGroupName)).setter(UpdateMultiRegionClusterRequest.setter(Builder::multiRegionParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName").build()}).build();
    private static final SdkField<String> UPDATE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStrategy").getter(UpdateMultiRegionClusterRequest.getter(UpdateMultiRegionClusterRequest::updateStrategyAsString)).setter(UpdateMultiRegionClusterRequest.setter(Builder::updateStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_CLUSTER_NAME_FIELD, NODE_TYPE_FIELD, DESCRIPTION_FIELD, ENGINE_VERSION_FIELD, SHARD_CONFIGURATION_FIELD, MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, UPDATE_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
            this.put("NodeType", NODE_TYPE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("ShardConfiguration", SHARD_CONFIGURATION_FIELD);
            this.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
            this.put("UpdateStrategy", UPDATE_STRATEGY_FIELD);
        }
    });
    private final String multiRegionClusterName;
    private final String nodeType;
    private final String description;
    private final String engineVersion;
    private final ShardConfigurationRequest shardConfiguration;
    private final String multiRegionParameterGroupName;
    private final String updateStrategy;

    private UpdateMultiRegionClusterRequest(BuilderImpl builder) {
        super(builder);
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.nodeType = builder.nodeType;
        this.description = builder.description;
        this.engineVersion = builder.engineVersion;
        this.shardConfiguration = builder.shardConfiguration;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.updateStrategy = builder.updateStrategy;
    }

    public final String multiRegionClusterName() {
        return this.multiRegionClusterName;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String description() {
        return this.description;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final ShardConfigurationRequest shardConfiguration() {
        return this.shardConfiguration;
    }

    public final String multiRegionParameterGroupName() {
        return this.multiRegionParameterGroupName;
    }

    public final UpdateStrategy updateStrategy() {
        return UpdateStrategy.fromValue(this.updateStrategy);
    }

    public final String updateStrategyAsString() {
        return this.updateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiRegionClusterRequest)) {
            return false;
        }
        UpdateMultiRegionClusterRequest other = (UpdateMultiRegionClusterRequest)((Object)obj);
        return Objects.equals(this.multiRegionClusterName(), other.multiRegionClusterName()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.shardConfiguration(), other.shardConfiguration()) && Objects.equals(this.multiRegionParameterGroupName(), other.multiRegionParameterGroupName()) && Objects.equals(this.updateStrategyAsString(), other.updateStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMultiRegionClusterRequest").add("MultiRegionClusterName", (Object)this.multiRegionClusterName()).add("NodeType", (Object)this.nodeType()).add("Description", (Object)this.description()).add("EngineVersion", (Object)this.engineVersion()).add("ShardConfiguration", (Object)this.shardConfiguration()).add("MultiRegionParameterGroupName", (Object)this.multiRegionParameterGroupName()).add("UpdateStrategy", (Object)this.updateStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiRegionClusterName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusterName()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ShardConfiguration": {
                return Optional.ofNullable(clazz.cast(this.shardConfiguration()));
            }
            case "MultiRegionParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameterGroupName()));
            }
            case "UpdateStrategy": {
                return Optional.ofNullable(clazz.cast(this.updateStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiRegionClusterRequest, T> g) {
        return obj -> g.apply((UpdateMultiRegionClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String multiRegionClusterName;
        private String nodeType;
        private String description;
        private String engineVersion;
        private ShardConfigurationRequest shardConfiguration;
        private String multiRegionParameterGroupName;
        private String updateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiRegionClusterRequest model) {
            super(model);
            this.multiRegionClusterName(model.multiRegionClusterName);
            this.nodeType(model.nodeType);
            this.description(model.description);
            this.engineVersion(model.engineVersion);
            this.shardConfiguration(model.shardConfiguration);
            this.multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            this.updateStrategy(model.updateStrategy);
        }

        public final String getMultiRegionClusterName() {
            return this.multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ShardConfigurationRequest.Builder getShardConfiguration() {
            return this.shardConfiguration != null ? this.shardConfiguration.toBuilder() : null;
        }

        public final void setShardConfiguration(ShardConfigurationRequest.BuilderImpl shardConfiguration) {
            this.shardConfiguration = shardConfiguration != null ? shardConfiguration.build() : null;
        }

        @Override
        public final Builder shardConfiguration(ShardConfigurationRequest shardConfiguration) {
            this.shardConfiguration = shardConfiguration;
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return this.multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final String getUpdateStrategy() {
            return this.updateStrategy;
        }

        public final void setUpdateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
        }

        @Override
        public final Builder updateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        @Override
        public final Builder updateStrategy(UpdateStrategy updateStrategy) {
            this.updateStrategy(updateStrategy == null ? null : updateStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiRegionClusterRequest build() {
            return new UpdateMultiRegionClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMultiRegionClusterRequest> {
        public Builder multiRegionClusterName(String var1);

        public Builder nodeType(String var1);

        public Builder description(String var1);

        public Builder engineVersion(String var1);

        public Builder shardConfiguration(ShardConfigurationRequest var1);

        default public Builder shardConfiguration(Consumer<ShardConfigurationRequest.Builder> shardConfiguration) {
            return this.shardConfiguration((ShardConfigurationRequest)((ShardConfigurationRequest.Builder)ShardConfigurationRequest.builder().applyMutation(shardConfiguration)).build());
        }

        public Builder multiRegionParameterGroupName(String var1);

        public Builder updateStrategy(String var1);

        public Builder updateStrategy(UpdateStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

