/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.Cluster;
import software.amazon.awssdk.services.memorydb.model.ClusterListCopier;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.UnprocessedCluster;
import software.amazon.awssdk.services.memorydb.model.UnprocessedClusterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateClusterResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, BatchUpdateClusterResponse> {
    private static final SdkField<List<Cluster>> PROCESSED_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedClusters").getter(BatchUpdateClusterResponse.getter(BatchUpdateClusterResponse::processedClusters)).setter(BatchUpdateClusterResponse.setter(Builder::processedClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedCluster>> UNPROCESSED_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedClusters").getter(BatchUpdateClusterResponse.getter(BatchUpdateClusterResponse::unprocessedClusters)).setter(BatchUpdateClusterResponse.setter(Builder::unprocessedClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_CLUSTERS_FIELD, UNPROCESSED_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProcessedClusters", PROCESSED_CLUSTERS_FIELD);
            this.put("UnprocessedClusters", UNPROCESSED_CLUSTERS_FIELD);
        }
    });
    private final List<Cluster> processedClusters;
    private final List<UnprocessedCluster> unprocessedClusters;

    private BatchUpdateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.processedClusters = builder.processedClusters;
        this.unprocessedClusters = builder.unprocessedClusters;
    }

    public final boolean hasProcessedClusters() {
        return this.processedClusters != null && !(this.processedClusters instanceof SdkAutoConstructList);
    }

    public final List<Cluster> processedClusters() {
        return this.processedClusters;
    }

    public final boolean hasUnprocessedClusters() {
        return this.unprocessedClusters != null && !(this.unprocessedClusters instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedCluster> unprocessedClusters() {
        return this.unprocessedClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedClusters() ? this.processedClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedClusters() ? this.unprocessedClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateClusterResponse)) {
            return false;
        }
        BatchUpdateClusterResponse other = (BatchUpdateClusterResponse)((Object)obj);
        return this.hasProcessedClusters() == other.hasProcessedClusters() && Objects.equals(this.processedClusters(), other.processedClusters()) && this.hasUnprocessedClusters() == other.hasUnprocessedClusters() && Objects.equals(this.unprocessedClusters(), other.unprocessedClusters());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateClusterResponse").add("ProcessedClusters", this.hasProcessedClusters() ? this.processedClusters() : null).add("UnprocessedClusters", this.hasUnprocessedClusters() ? this.unprocessedClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedClusters": {
                return Optional.ofNullable(clazz.cast(this.processedClusters()));
            }
            case "UnprocessedClusters": {
                return Optional.ofNullable(clazz.cast(this.unprocessedClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateClusterResponse, T> g) {
        return obj -> g.apply((BatchUpdateClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private List<Cluster> processedClusters = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedCluster> unprocessedClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateClusterResponse model) {
            super(model);
            this.processedClusters(model.processedClusters);
            this.unprocessedClusters(model.unprocessedClusters);
        }

        public final List<Cluster.Builder> getProcessedClusters() {
            List<Cluster.Builder> result = ClusterListCopier.copyToBuilder(this.processedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedClusters(Collection<Cluster.BuilderImpl> processedClusters) {
            this.processedClusters = ClusterListCopier.copyFromBuilder(processedClusters);
        }

        @Override
        public final Builder processedClusters(Collection<Cluster> processedClusters) {
            this.processedClusters = ClusterListCopier.copy(processedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedClusters(Cluster ... processedClusters) {
            this.processedClusters(Arrays.asList(processedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedClusters(Consumer<Cluster.Builder> ... processedClusters) {
            this.processedClusters(Stream.of(processedClusters).map(c -> (Cluster)((Cluster.Builder)Cluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedCluster.Builder> getUnprocessedClusters() {
            List<UnprocessedCluster.Builder> result = UnprocessedClusterListCopier.copyToBuilder(this.unprocessedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedClusters(Collection<UnprocessedCluster.BuilderImpl> unprocessedClusters) {
            this.unprocessedClusters = UnprocessedClusterListCopier.copyFromBuilder(unprocessedClusters);
        }

        @Override
        public final Builder unprocessedClusters(Collection<UnprocessedCluster> unprocessedClusters) {
            this.unprocessedClusters = UnprocessedClusterListCopier.copy(unprocessedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedClusters(UnprocessedCluster ... unprocessedClusters) {
            this.unprocessedClusters(Arrays.asList(unprocessedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedClusters(Consumer<UnprocessedCluster.Builder> ... unprocessedClusters) {
            this.unprocessedClusters(Stream.of(unprocessedClusters).map(c -> (UnprocessedCluster)((UnprocessedCluster.Builder)UnprocessedCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateClusterResponse build() {
            return new BatchUpdateClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateClusterResponse> {
        public Builder processedClusters(Collection<Cluster> var1);

        public Builder processedClusters(Cluster ... var1);

        public Builder processedClusters(Consumer<Cluster.Builder> ... var1);

        public Builder unprocessedClusters(Collection<UnprocessedCluster> var1);

        public Builder unprocessedClusters(UnprocessedCluster ... var1);

        public Builder unprocessedClusters(Consumer<UnprocessedCluster.Builder> ... var1);
    }
}

