/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.memorydb.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(CreateClusterRequest.getter(CreateClusterRequest::nodeType)).setter(CreateClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(CreateClusterRequest.getter(CreateClusterRequest::parameterGroupName)).setter(CreateClusterRequest.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateClusterRequest.getter(CreateClusterRequest::description)).setter(CreateClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumShards").getter(CreateClusterRequest.getter(CreateClusterRequest::numShards)).setter(CreateClusterRequest.setter(Builder::numShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()}).build();
    private static final SdkField<Integer> NUM_REPLICAS_PER_SHARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumReplicasPerShard").getter(CreateClusterRequest.getter(CreateClusterRequest::numReplicasPerShard)).setter(CreateClusterRequest.setter(Builder::numReplicasPerShard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumReplicasPerShard").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupName").getter(CreateClusterRequest.getter(CreateClusterRequest::subnetGroupName)).setter(CreateClusterRequest.setter(Builder::subnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateClusterRequest.getter(CreateClusterRequest::securityGroupIds)).setter(CreateClusterRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceWindow").getter(CreateClusterRequest.getter(CreateClusterRequest::maintenanceWindow)).setter(CreateClusterRequest.setter(Builder::maintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateClusterRequest.getter(CreateClusterRequest::port)).setter(CreateClusterRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(CreateClusterRequest.getter(CreateClusterRequest::snsTopicArn)).setter(CreateClusterRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TLSEnabled").getter(CreateClusterRequest.getter(CreateClusterRequest::tlsEnabled)).setter(CreateClusterRequest.setter(Builder::tlsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateClusterRequest.getter(CreateClusterRequest::kmsKeyId)).setter(CreateClusterRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotArns").getter(CreateClusterRequest.getter(CreateClusterRequest::snapshotArns)).setter(CreateClusterRequest.setter(Builder::snapshotArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotName").getter(CreateClusterRequest.getter(CreateClusterRequest::snapshotName)).setter(CreateClusterRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(CreateClusterRequest.getter(CreateClusterRequest::snapshotRetentionLimit)).setter(CreateClusterRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(CreateClusterRequest.getter(CreateClusterRequest::snapshotWindow)).setter(CreateClusterRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ACLName").getter(CreateClusterRequest.getter(CreateClusterRequest::aclName)).setter(CreateClusterRequest.setter(Builder::aclName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateClusterRequest.getter(CreateClusterRequest::engine)).setter(CreateClusterRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateClusterRequest.getter(CreateClusterRequest::engineVersion)).setter(CreateClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CreateClusterRequest.getter(CreateClusterRequest::autoMinorVersionUpgrade)).setter(CreateClusterRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Boolean> DATA_TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataTiering").getter(CreateClusterRequest.getter(CreateClusterRequest::dataTiering)).setter(CreateClusterRequest.setter(Builder::dataTiering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODE_TYPE_FIELD, PARAMETER_GROUP_NAME_FIELD, DESCRIPTION_FIELD, NUM_SHARDS_FIELD, NUM_REPLICAS_PER_SHARD_FIELD, SUBNET_GROUP_NAME_FIELD, SECURITY_GROUP_IDS_FIELD, MAINTENANCE_WINDOW_FIELD, PORT_FIELD, SNS_TOPIC_ARN_FIELD, TLS_ENABLED_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, TAGS_FIELD, SNAPSHOT_WINDOW_FIELD, ACL_NAME_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, DATA_TIERING_FIELD));
    private final String clusterName;
    private final String nodeType;
    private final String parameterGroupName;
    private final String description;
    private final Integer numShards;
    private final Integer numReplicasPerShard;
    private final String subnetGroupName;
    private final List<String> securityGroupIds;
    private final String maintenanceWindow;
    private final Integer port;
    private final String snsTopicArn;
    private final Boolean tlsEnabled;
    private final String kmsKeyId;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final Integer snapshotRetentionLimit;
    private final List<Tag> tags;
    private final String snapshotWindow;
    private final String aclName;
    private final String engine;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Boolean dataTiering;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeType = builder.nodeType;
        this.parameterGroupName = builder.parameterGroupName;
        this.description = builder.description;
        this.numShards = builder.numShards;
        this.numReplicasPerShard = builder.numReplicasPerShard;
        this.subnetGroupName = builder.subnetGroupName;
        this.securityGroupIds = builder.securityGroupIds;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.port = builder.port;
        this.snsTopicArn = builder.snsTopicArn;
        this.tlsEnabled = builder.tlsEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.tags = builder.tags;
        this.snapshotWindow = builder.snapshotWindow;
        this.aclName = builder.aclName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.dataTiering = builder.dataTiering;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final Integer numShards() {
        return this.numShards;
    }

    public final Integer numReplicasPerShard() {
        return this.numReplicasPerShard;
    }

    public final String subnetGroupName() {
        return this.subnetGroupName;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final Integer port() {
        return this.port;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final Boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasSnapshotArns() {
        return this.snapshotArns != null && !(this.snapshotArns instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final String aclName() {
        return this.aclName;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Boolean dataTiering() {
        return this.dataTiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.numShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.numReplicasPerShard());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotArns() ? this.snapshotArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTiering());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.numShards(), other.numShards()) && Objects.equals(this.numReplicasPerShard(), other.numReplicasPerShard()) && Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.tlsEnabled(), other.tlsEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasSnapshotArns() == other.hasSnapshotArns() && Objects.equals(this.snapshotArns(), other.snapshotArns()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.aclName(), other.aclName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.dataTiering(), other.dataTiering());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("NodeType", (Object)this.nodeType()).add("ParameterGroupName", (Object)this.parameterGroupName()).add("Description", (Object)this.description()).add("NumShards", (Object)this.numShards()).add("NumReplicasPerShard", (Object)this.numReplicasPerShard()).add("SubnetGroupName", (Object)this.subnetGroupName()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("Port", (Object)this.port()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("TLSEnabled", (Object)this.tlsEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnapshotArns", this.hasSnapshotArns() ? this.snapshotArns() : null).add("SnapshotName", (Object)this.snapshotName()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("Tags", this.hasTags() ? this.tags() : null).add("SnapshotWindow", (Object)this.snapshotWindow()).add("ACLName", (Object)this.aclName()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("DataTiering", (Object)this.dataTiering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NumShards": {
                return Optional.ofNullable(clazz.cast(this.numShards()));
            }
            case "NumReplicasPerShard": {
                return Optional.ofNullable(clazz.cast(this.numReplicasPerShard()));
            }
            case "SubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupName()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "MaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "TLSEnabled": {
                return Optional.ofNullable(clazz.cast(this.tlsEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SnapshotArns": {
                return Optional.ofNullable(clazz.cast(this.snapshotArns()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "ACLName": {
                return Optional.ofNullable(clazz.cast(this.aclName()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "DataTiering": {
                return Optional.ofNullable(clazz.cast(this.dataTiering()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodeType;
        private String parameterGroupName;
        private String description;
        private Integer numShards;
        private Integer numReplicasPerShard;
        private String subnetGroupName;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String maintenanceWindow;
        private Integer port;
        private String snsTopicArn;
        private Boolean tlsEnabled;
        private String kmsKeyId;
        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();
        private String snapshotName;
        private Integer snapshotRetentionLimit;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String snapshotWindow;
        private String aclName;
        private String engine;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Boolean dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodeType(model.nodeType);
            this.parameterGroupName(model.parameterGroupName);
            this.description(model.description);
            this.numShards(model.numShards);
            this.numReplicasPerShard(model.numReplicasPerShard);
            this.subnetGroupName(model.subnetGroupName);
            this.securityGroupIds(model.securityGroupIds);
            this.maintenanceWindow(model.maintenanceWindow);
            this.port(model.port);
            this.snsTopicArn(model.snsTopicArn);
            this.tlsEnabled(model.tlsEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.snapshotArns(model.snapshotArns);
            this.snapshotName(model.snapshotName);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.tags(model.tags);
            this.snapshotWindow(model.snapshotWindow);
            this.aclName(model.aclName);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.dataTiering(model.dataTiering);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getNumShards() {
            return this.numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final Integer getNumReplicasPerShard() {
            return this.numReplicasPerShard;
        }

        public final void setNumReplicasPerShard(Integer numReplicasPerShard) {
            this.numReplicasPerShard = numReplicasPerShard;
        }

        @Override
        public final Builder numReplicasPerShard(Integer numReplicasPerShard) {
            this.numReplicasPerShard = numReplicasPerShard;
            return this;
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return this.tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSnapshotArns() {
            if (this.snapshotArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotArns;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAclName() {
            return this.aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Boolean getDataTiering() {
            return this.dataTiering;
        }

        public final void setDataTiering(Boolean dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(Boolean dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder nodeType(String var1);

        public Builder parameterGroupName(String var1);

        public Builder description(String var1);

        public Builder numShards(Integer var1);

        public Builder numReplicasPerShard(Integer var1);

        public Builder subnetGroupName(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder maintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder snsTopicArn(String var1);

        public Builder tlsEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder snapshotWindow(String var1);

        public Builder aclName(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder dataTiering(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

