/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.memorydb.model.AvailabilityZone;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subnet> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(Subnet.getter(Subnet::identifier)).setter(Subnet.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<AvailabilityZone> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailabilityZone").getter(Subnet.getter(Subnet::availabilityZone)).setter(Subnet.setter(Builder::availabilityZone)).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final AvailabilityZone availabilityZone;

    private Subnet(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final AvailabilityZone availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"Subnet").add("Identifier", (Object)this.identifier()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private AvailabilityZone availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.identifier(model.identifier);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final AvailabilityZone.Builder getAvailabilityZone() {
            return this.availabilityZone != null ? this.availabilityZone.toBuilder() : null;
        }

        public final void setAvailabilityZone(AvailabilityZone.BuilderImpl availabilityZone) {
            this.availabilityZone = availabilityZone != null ? availabilityZone.build() : null;
        }

        @Override
        public final Builder availabilityZone(AvailabilityZone availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Subnet build() {
            return new Subnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subnet> {
        public Builder identifier(String var1);

        public Builder availabilityZone(AvailabilityZone var1);

        default public Builder availabilityZone(Consumer<AvailabilityZone.Builder> availabilityZone) {
            return this.availabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation(availabilityZone)).build());
        }
    }
}

