/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNode;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedNodesResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeReservedNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedNodesResponse.getter(DescribeReservedNodesResponse::nextToken)).setter(DescribeReservedNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedNode>> RESERVED_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedNodes").getter(DescribeReservedNodesResponse.getter(DescribeReservedNodesResponse::reservedNodes)).setter(DescribeReservedNodesResponse.setter(Builder::reservedNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_NODES_FIELD));
    private final String nextToken;
    private final List<ReservedNode> reservedNodes;

    private DescribeReservedNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedNodes = builder.reservedNodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedNodes() {
        return this.reservedNodes != null && !(this.reservedNodes instanceof SdkAutoConstructList);
    }

    public final List<ReservedNode> reservedNodes() {
        return this.reservedNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedNodes() ? this.reservedNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesResponse)) {
            return false;
        }
        DescribeReservedNodesResponse other = (DescribeReservedNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedNodes() == other.hasReservedNodes() && Objects.equals(this.reservedNodes(), other.reservedNodes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedNodesResponse").add("NextToken", (Object)this.nextToken()).add("ReservedNodes", this.hasReservedNodes() ? this.reservedNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedNodes": {
                return Optional.ofNullable(clazz.cast(this.reservedNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedNode> reservedNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedNodes(model.reservedNodes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedNode.Builder> getReservedNodes() {
            List<ReservedNode.Builder> result = ReservedNodeListCopier.copyToBuilder(this.reservedNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedNodes(Collection<ReservedNode.BuilderImpl> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copyFromBuilder(reservedNodes);
        }

        @Override
        public final Builder reservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(ReservedNode ... reservedNodes) {
            this.reservedNodes(Arrays.asList(reservedNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(Consumer<ReservedNode.Builder> ... reservedNodes) {
            this.reservedNodes(Stream.of(reservedNodes).map(c -> (ReservedNode)((ReservedNode.Builder)ReservedNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedNodesResponse build() {
            return new DescribeReservedNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedNodesResponse> {
        public Builder nextToken(String var1);

        public Builder reservedNodes(Collection<ReservedNode> var1);

        public Builder reservedNodes(ReservedNode ... var1);

        public Builder reservedNodes(Consumer<ReservedNode.Builder> ... var1);
    }
}

