/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering;

public class DescribeReservedNodesOfferingsIterable
implements SdkIterable<DescribeReservedNodesOfferingsResponse> {
    private final MemoryDbClient client;
    private final DescribeReservedNodesOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodesOfferingsIterable(MemoryDbClient client, DescribeReservedNodesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedNodesOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNodesOffering> reservedNodesOfferings() {
        Function<DescribeReservedNodesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodesOfferings() != null) {
                return response.reservedNodesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedNodesOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodesOfferingsResponse> {
        private DescribeReservedNodesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedNodesOfferingsResponse nextPage(DescribeReservedNodesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesOfferingsIterable.this.client.describeReservedNodesOfferings(DescribeReservedNodesOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedNodesOfferingsIterable.this.client.describeReservedNodesOfferings((DescribeReservedNodesOfferingsRequest)((Object)DescribeReservedNodesOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

