/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdate;

public class DescribeServiceUpdatesPublisher
implements SdkPublisher<DescribeServiceUpdatesResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeServiceUpdatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServiceUpdatesPublisher(MemoryDbAsyncClient client, DescribeServiceUpdatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServiceUpdatesPublisher(MemoryDbAsyncClient client, DescribeServiceUpdatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServiceUpdatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServiceUpdatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceUpdate> serviceUpdates() {
        Function<DescribeServiceUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceUpdates() != null) {
                return response.serviceUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeServiceUpdatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeServiceUpdatesResponseFetcher
    implements AsyncPageFetcher<DescribeServiceUpdatesResponse> {
        private DescribeServiceUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServiceUpdatesResponse> nextPage(DescribeServiceUpdatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceUpdatesPublisher.this.client.describeServiceUpdates(DescribeServiceUpdatesPublisher.this.firstRequest);
            }
            return DescribeServiceUpdatesPublisher.this.client.describeServiceUpdates((DescribeServiceUpdatesRequest)((Object)DescribeServiceUpdatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

