/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.Snapshot;

public class DescribeSnapshotsPublisher
implements SdkPublisher<DescribeSnapshotsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotsPublisher(MemoryDbAsyncClient client, DescribeSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotsPublisher(MemoryDbAsyncClient client, DescribeSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Snapshot> snapshots() {
        Function<DescribeSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSnapshotsResponse> nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsPublisher.this.client.describeSnapshots(DescribeSnapshotsPublisher.this.firstRequest);
            }
            return DescribeSnapshotsPublisher.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

