/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.services.memorydb.model.UserNameListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAclRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, CreateAclRequest> {
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ACLName").getter(CreateAclRequest.getter(CreateAclRequest::aclName)).setter(CreateAclRequest.setter(Builder::aclName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()}).build();
    private static final SdkField<List<String>> USER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNames").getter(CreateAclRequest.getter(CreateAclRequest::userNames)).setter(CreateAclRequest.setter(Builder::userNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAclRequest.getter(CreateAclRequest::tags)).setter(CreateAclRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_NAME_FIELD, USER_NAMES_FIELD, TAGS_FIELD));
    private final String aclName;
    private final List<String> userNames;
    private final List<Tag> tags;

    private CreateAclRequest(BuilderImpl builder) {
        super(builder);
        this.aclName = builder.aclName;
        this.userNames = builder.userNames;
        this.tags = builder.tags;
    }

    public final String aclName() {
        return this.aclName;
    }

    public final boolean hasUserNames() {
        return this.userNames != null && !(this.userNames instanceof SdkAutoConstructList);
    }

    public final List<String> userNames() {
        return this.userNames;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aclName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNames() ? this.userNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAclRequest)) {
            return false;
        }
        CreateAclRequest other = (CreateAclRequest)((Object)obj);
        return Objects.equals(this.aclName(), other.aclName()) && this.hasUserNames() == other.hasUserNames() && Objects.equals(this.userNames(), other.userNames()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAclRequest").add("ACLName", (Object)this.aclName()).add("UserNames", this.hasUserNames() ? this.userNames() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACLName": {
                return Optional.ofNullable(clazz.cast(this.aclName()));
            }
            case "UserNames": {
                return Optional.ofNullable(clazz.cast(this.userNames()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAclRequest, T> g) {
        return obj -> g.apply((CreateAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String aclName;
        private List<String> userNames = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAclRequest model) {
            super(model);
            this.aclName(model.aclName);
            this.userNames(model.userNames);
            this.tags(model.tags);
        }

        public final String getAclName() {
            return this.aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        @Transient
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final Collection<String> getUserNames() {
            if (this.userNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNames;
        }

        public final void setUserNames(Collection<String> userNames) {
            this.userNames = UserNameListInputCopier.copy(userNames);
        }

        @Override
        @Transient
        public final Builder userNames(Collection<String> userNames) {
            this.userNames = UserNameListInputCopier.copy(userNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userNames(String ... userNames) {
            this.userNames(Arrays.asList(userNames));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAclRequest build() {
            return new CreateAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAclRequest> {
        public Builder aclName(String var1);

        public Builder userNames(Collection<String> var1);

        public Builder userNames(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

