/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.EngineVersionInfo;
import software.amazon.awssdk.services.memorydb.model.EngineVersionInfoListCopier;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEngineVersionsResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeEngineVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEngineVersionsResponse.getter(DescribeEngineVersionsResponse::nextToken)).setter(DescribeEngineVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<EngineVersionInfo>> ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngineVersions").getter(DescribeEngineVersionsResponse.getter(DescribeEngineVersionsResponse::engineVersions)).setter(DescribeEngineVersionsResponse.setter(Builder::engineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineVersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENGINE_VERSIONS_FIELD));
    private final String nextToken;
    private final List<EngineVersionInfo> engineVersions;

    private DescribeEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.engineVersions = builder.engineVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEngineVersions() {
        return this.engineVersions != null && !(this.engineVersions instanceof SdkAutoConstructList);
    }

    public final List<EngineVersionInfo> engineVersions() {
        return this.engineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngineVersions() ? this.engineVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineVersionsResponse)) {
            return false;
        }
        DescribeEngineVersionsResponse other = (DescribeEngineVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEngineVersions() == other.hasEngineVersions() && Objects.equals(this.engineVersions(), other.engineVersions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEngineVersionsResponse").add("NextToken", (Object)this.nextToken()).add("EngineVersions", this.hasEngineVersions() ? this.engineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "EngineVersions": {
                return Optional.ofNullable(clazz.cast(this.engineVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeEngineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EngineVersionInfo> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.engineVersions(model.engineVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EngineVersionInfo.Builder> getEngineVersions() {
            List<EngineVersionInfo.Builder> result = EngineVersionInfoListCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineVersions(Collection<EngineVersionInfo.BuilderImpl> engineVersions) {
            this.engineVersions = EngineVersionInfoListCopier.copyFromBuilder(engineVersions);
        }

        @Override
        @Transient
        public final Builder engineVersions(Collection<EngineVersionInfo> engineVersions) {
            this.engineVersions = EngineVersionInfoListCopier.copy(engineVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder engineVersions(EngineVersionInfo ... engineVersions) {
            this.engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersionInfo.Builder> ... engineVersions) {
            this.engineVersions(Stream.of(engineVersions).map(c -> (EngineVersionInfo)((EngineVersionInfo.Builder)EngineVersionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEngineVersionsResponse build() {
            return new DescribeEngineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEngineVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder engineVersions(Collection<EngineVersionInfo> var1);

        public Builder engineVersions(EngineVersionInfo ... var1);

        public Builder engineVersions(Consumer<EngineVersionInfo.Builder> ... var1);
    }
}

