/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.AccelerationSettings;
import software.amazon.awssdk.services.mediaconvert.model.BillingTagsSource;
import software.amazon.awssdk.services.mediaconvert.model.JobPhase;
import software.amazon.awssdk.services.mediaconvert.model.JobSettings;
import software.amazon.awssdk.services.mediaconvert.model.JobStatus;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupDetail;
import software.amazon.awssdk.services.mediaconvert.model.StatusUpdateInterval;
import software.amazon.awssdk.services.mediaconvert.model.Timing;
import software.amazon.awssdk.services.mediaconvert.model.___listOfOutputGroupDetailCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::accelerationSettings)).setter(Job.setter(Builder::accelerationSettings)).constructor(AccelerationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::arn)).setter(Job.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BILLING_TAGS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::billingTagsSourceAsString)).setter(Job.setter(Builder::billingTagsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingTagsSource").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Job.getter(Job::createdAt)).setter(Job.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::currentPhaseAsString)).setter(Job.setter(Builder::currentPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()}).build();
    private static final SdkField<Integer> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Job.getter(Job::errorCode)).setter(Job.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::errorMessage)).setter(Job.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::id)).setter(Job.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Integer> JOB_PERCENT_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Job.getter(Job::jobPercentComplete)).setter(Job.setter(Builder::jobPercentComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobPercentComplete").build()}).build();
    private static final SdkField<String> JOB_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::jobTemplate)).setter(Job.setter(Builder::jobTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplate").build()}).build();
    private static final SdkField<List<OutputGroupDetail>> OUTPUT_GROUP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Job.getter(Job::outputGroupDetails)).setter(Job.setter(Builder::outputGroupDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroupDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputGroupDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Job.getter(Job::priority)).setter(Job.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::queue)).setter(Job.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<Integer> RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Job.getter(Job::retryCount)).setter(Job.setter(Builder::retryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryCount").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::role)).setter(Job.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<JobSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::settings)).setter(Job.setter(Builder::settings)).constructor(JobSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::statusAsString)).setter(Job.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::statusUpdateIntervalAsString)).setter(Job.setter(Builder::statusUpdateInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build()}).build();
    private static final SdkField<Timing> TIMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::timing)).setter(Job.setter(Builder::timing)).constructor(Timing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timing").build()}).build();
    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Job.getter(Job::userMetadata)).setter(Job.setter(Builder::userMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD, ARN_FIELD, BILLING_TAGS_SOURCE_FIELD, CREATED_AT_FIELD, CURRENT_PHASE_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, JOB_PERCENT_COMPLETE_FIELD, JOB_TEMPLATE_FIELD, OUTPUT_GROUP_DETAILS_FIELD, PRIORITY_FIELD, QUEUE_FIELD, RETRY_COUNT_FIELD, ROLE_FIELD, SETTINGS_FIELD, STATUS_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TIMING_FIELD, USER_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccelerationSettings accelerationSettings;
    private final String arn;
    private final String billingTagsSource;
    private final Instant createdAt;
    private final String currentPhase;
    private final Integer errorCode;
    private final String errorMessage;
    private final String id;
    private final Integer jobPercentComplete;
    private final String jobTemplate;
    private final List<OutputGroupDetail> outputGroupDetails;
    private final Integer priority;
    private final String queue;
    private final Integer retryCount;
    private final String role;
    private final JobSettings settings;
    private final String status;
    private final String statusUpdateInterval;
    private final Timing timing;
    private final Map<String, String> userMetadata;

    private Job(BuilderImpl builder) {
        this.accelerationSettings = builder.accelerationSettings;
        this.arn = builder.arn;
        this.billingTagsSource = builder.billingTagsSource;
        this.createdAt = builder.createdAt;
        this.currentPhase = builder.currentPhase;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.jobPercentComplete = builder.jobPercentComplete;
        this.jobTemplate = builder.jobTemplate;
        this.outputGroupDetails = builder.outputGroupDetails;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.retryCount = builder.retryCount;
        this.role = builder.role;
        this.settings = builder.settings;
        this.status = builder.status;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.timing = builder.timing;
        this.userMetadata = builder.userMetadata;
    }

    public AccelerationSettings accelerationSettings() {
        return this.accelerationSettings;
    }

    public String arn() {
        return this.arn;
    }

    public BillingTagsSource billingTagsSource() {
        return BillingTagsSource.fromValue(this.billingTagsSource);
    }

    public String billingTagsSourceAsString() {
        return this.billingTagsSource;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public JobPhase currentPhase() {
        return JobPhase.fromValue(this.currentPhase);
    }

    public String currentPhaseAsString() {
        return this.currentPhase;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String id() {
        return this.id;
    }

    public Integer jobPercentComplete() {
        return this.jobPercentComplete;
    }

    public String jobTemplate() {
        return this.jobTemplate;
    }

    public List<OutputGroupDetail> outputGroupDetails() {
        return this.outputGroupDetails;
    }

    public Integer priority() {
        return this.priority;
    }

    public String queue() {
        return this.queue;
    }

    public Integer retryCount() {
        return this.retryCount;
    }

    public String role() {
        return this.role;
    }

    public JobSettings settings() {
        return this.settings;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(this.statusUpdateInterval);
    }

    public String statusUpdateIntervalAsString() {
        return this.statusUpdateInterval;
    }

    public Timing timing() {
        return this.timing;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingTagsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobPercentComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timing());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.accelerationSettings(), other.accelerationSettings()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.billingTagsSourceAsString(), other.billingTagsSourceAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.currentPhaseAsString(), other.currentPhaseAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.jobPercentComplete(), other.jobPercentComplete()) && Objects.equals(this.jobTemplate(), other.jobTemplate()) && Objects.equals(this.outputGroupDetails(), other.outputGroupDetails()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.retryCount(), other.retryCount()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString()) && Objects.equals(this.timing(), other.timing()) && Objects.equals(this.userMetadata(), other.userMetadata());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("AccelerationSettings", (Object)this.accelerationSettings()).add("Arn", (Object)this.arn()).add("BillingTagsSource", (Object)this.billingTagsSourceAsString()).add("CreatedAt", (Object)this.createdAt()).add("CurrentPhase", (Object)this.currentPhaseAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("Id", (Object)this.id()).add("JobPercentComplete", (Object)this.jobPercentComplete()).add("JobTemplate", (Object)this.jobTemplate()).add("OutputGroupDetails", this.outputGroupDetails()).add("Priority", (Object)this.priority()).add("Queue", (Object)this.queue()).add("RetryCount", (Object)this.retryCount()).add("Role", (Object)this.role()).add("Settings", (Object)this.settings()).add("Status", (Object)this.statusAsString()).add("StatusUpdateInterval", (Object)this.statusUpdateIntervalAsString()).add("Timing", (Object)this.timing()).add("UserMetadata", this.userMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccelerationSettings": {
                return Optional.ofNullable(clazz.cast(this.accelerationSettings()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BillingTagsSource": {
                return Optional.ofNullable(clazz.cast(this.billingTagsSourceAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CurrentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhaseAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "JobPercentComplete": {
                return Optional.ofNullable(clazz.cast(this.jobPercentComplete()));
            }
            case "JobTemplate": {
                return Optional.ofNullable(clazz.cast(this.jobTemplate()));
            }
            case "OutputGroupDetails": {
                return Optional.ofNullable(clazz.cast(this.outputGroupDetails()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "RetryCount": {
                return Optional.ofNullable(clazz.cast(this.retryCount()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusUpdateInterval": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateIntervalAsString()));
            }
            case "Timing": {
                return Optional.ofNullable(clazz.cast(this.timing()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccelerationSettings accelerationSettings;
        private String arn;
        private String billingTagsSource;
        private Instant createdAt;
        private String currentPhase;
        private Integer errorCode;
        private String errorMessage;
        private String id;
        private Integer jobPercentComplete;
        private String jobTemplate;
        private List<OutputGroupDetail> outputGroupDetails = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private String queue;
        private Integer retryCount;
        private String role;
        private JobSettings settings;
        private String status;
        private String statusUpdateInterval;
        private Timing timing;
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.accelerationSettings(model.accelerationSettings);
            this.arn(model.arn);
            this.billingTagsSource(model.billingTagsSource);
            this.createdAt(model.createdAt);
            this.currentPhase(model.currentPhase);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.id(model.id);
            this.jobPercentComplete(model.jobPercentComplete);
            this.jobTemplate(model.jobTemplate);
            this.outputGroupDetails(model.outputGroupDetails);
            this.priority(model.priority);
            this.queue(model.queue);
            this.retryCount(model.retryCount);
            this.role(model.role);
            this.settings(model.settings);
            this.status(model.status);
            this.statusUpdateInterval(model.statusUpdateInterval);
            this.timing(model.timing);
            this.userMetadata(model.userMetadata);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return this.accelerationSettings != null ? this.accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBillingTagsSourceAsString() {
            return this.billingTagsSource;
        }

        @Override
        public final Builder billingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
            return this;
        }

        @Override
        public final Builder billingTagsSource(BillingTagsSource billingTagsSource) {
            this.billingTagsSource(billingTagsSource == null ? null : billingTagsSource.toString());
            return this;
        }

        public final void setBillingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCurrentPhaseAsString() {
            return this.currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        @Override
        public final Builder currentPhase(JobPhase currentPhase) {
            this.currentPhase(currentPhase == null ? null : currentPhase.toString());
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final Integer getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getJobPercentComplete() {
            return this.jobPercentComplete;
        }

        @Override
        public final Builder jobPercentComplete(Integer jobPercentComplete) {
            this.jobPercentComplete = jobPercentComplete;
            return this;
        }

        public final void setJobPercentComplete(Integer jobPercentComplete) {
            this.jobPercentComplete = jobPercentComplete;
        }

        public final String getJobTemplate() {
            return this.jobTemplate;
        }

        @Override
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        public final Collection<OutputGroupDetail.Builder> getOutputGroupDetails() {
            return this.outputGroupDetails != null ? (Collection)this.outputGroupDetails.stream().map(OutputGroupDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails) {
            this.outputGroupDetails = ___listOfOutputGroupDetailCopier.copy(outputGroupDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(OutputGroupDetail ... outputGroupDetails) {
            this.outputGroupDetails(Arrays.asList(outputGroupDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder> ... outputGroupDetails) {
            this.outputGroupDetails(Stream.of(outputGroupDetails).map(c -> (OutputGroupDetail)((OutputGroupDetail.Builder)OutputGroupDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroupDetails(Collection<OutputGroupDetail.BuilderImpl> outputGroupDetails) {
            this.outputGroupDetails = ___listOfOutputGroupDetailCopier.copyFromBuilder(outputGroupDetails);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final Integer getRetryCount() {
            return this.retryCount;
        }

        @Override
        public final Builder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public final void setRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final JobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusUpdateIntervalAsString() {
            return this.statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final Timing.Builder getTiming() {
            return this.timing != null ? this.timing.toBuilder() : null;
        }

        @Override
        public final Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public final void setTiming(Timing.BuilderImpl timing) {
            this.timing = timing != null ? timing.build() : null;
        }

        public final Map<String, String> getUserMetadata() {
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder accelerationSettings(AccelerationSettings var1);

        default public Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return this.accelerationSettings((AccelerationSettings)((AccelerationSettings.Builder)AccelerationSettings.builder().applyMutation(accelerationSettings)).build());
        }

        public Builder arn(String var1);

        public Builder billingTagsSource(String var1);

        public Builder billingTagsSource(BillingTagsSource var1);

        public Builder createdAt(Instant var1);

        public Builder currentPhase(String var1);

        public Builder currentPhase(JobPhase var1);

        public Builder errorCode(Integer var1);

        public Builder errorMessage(String var1);

        public Builder id(String var1);

        public Builder jobPercentComplete(Integer var1);

        public Builder jobTemplate(String var1);

        public Builder outputGroupDetails(Collection<OutputGroupDetail> var1);

        public Builder outputGroupDetails(OutputGroupDetail ... var1);

        public Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder queue(String var1);

        public Builder retryCount(Integer var1);

        public Builder role(String var1);

        public Builder settings(JobSettings var1);

        default public Builder settings(Consumer<JobSettings.Builder> settings) {
            return this.settings((JobSettings)((JobSettings.Builder)JobSettings.builder().applyMutation(settings)).build());
        }

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder statusUpdateInterval(String var1);

        public Builder statusUpdateInterval(StatusUpdateInterval var1);

        public Builder timing(Timing var1);

        default public Builder timing(Consumer<Timing.Builder> timing) {
            return this.timing((Timing)((Timing.Builder)Timing.builder().applyMutation(timing)).build());
        }

        public Builder userMetadata(Map<String, String> var1);
    }
}

