/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoHbbtvCompliance;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoWriteSegmentTimelineInRepresentation;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashIsoGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashIsoGroupSettings> {
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::baseUrl)).setter(DashIsoGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::destination)).setter(DashIsoGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::destinationSettings)).setter(DashIsoGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<DashIsoEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::encryption)).setter(DashIsoGroupSettings.setter(Builder::encryption)).constructor(DashIsoEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::fragmentLength)).setter(DashIsoGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> HBBTV_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::hbbtvComplianceAsString)).setter(DashIsoGroupSettings.setter(Builder::hbbtvCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hbbtvCompliance").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::minBufferTime)).setter(DashIsoGroupSettings.setter(Builder::minBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::segmentControlAsString)).setter(DashIsoGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::segmentLength)).setter(DashIsoGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::writeSegmentTimelineInRepresentationAsString)).setter(DashIsoGroupSettings.setter(Builder::writeSegmentTimelineInRepresentation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeSegmentTimelineInRepresentation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_URL_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, HBBTV_COMPLIANCE_FIELD, MIN_BUFFER_TIME_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String baseUrl;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final DashIsoEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String hbbtvCompliance;
    private final Integer minBufferTime;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String writeSegmentTimelineInRepresentation;

    private DashIsoGroupSettings(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.hbbtvCompliance = builder.hbbtvCompliance;
        this.minBufferTime = builder.minBufferTime;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String destination() {
        return this.destination;
    }

    public DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public DashIsoEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public DashIsoHbbtvCompliance hbbtvCompliance() {
        return DashIsoHbbtvCompliance.fromValue(this.hbbtvCompliance);
    }

    public String hbbtvComplianceAsString() {
        return this.hbbtvCompliance;
    }

    public Integer minBufferTime() {
        return this.minBufferTime;
    }

    public DashIsoSegmentControl segmentControl() {
        return DashIsoSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlAsString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return DashIsoWriteSegmentTimelineInRepresentation.fromValue(this.writeSegmentTimelineInRepresentation);
    }

    public String writeSegmentTimelineInRepresentationAsString() {
        return this.writeSegmentTimelineInRepresentation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hbbtvComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoGroupSettings)) {
            return false;
        }
        DashIsoGroupSettings other = (DashIsoGroupSettings)obj;
        return Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.hbbtvComplianceAsString(), other.hbbtvComplianceAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.writeSegmentTimelineInRepresentationAsString(), other.writeSegmentTimelineInRepresentationAsString());
    }

    public String toString() {
        return ToString.builder((String)"DashIsoGroupSettings").add("BaseUrl", (Object)this.baseUrl()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("HbbtvCompliance", (Object)this.hbbtvComplianceAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("WriteSegmentTimelineInRepresentation", (Object)this.writeSegmentTimelineInRepresentationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "HbbtvCompliance": {
                return Optional.ofNullable(clazz.cast(this.hbbtvComplianceAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "WriteSegmentTimelineInRepresentation": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentTimelineInRepresentationAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashIsoGroupSettings, T> g) {
        return obj -> g.apply((DashIsoGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseUrl;
        private String destination;
        private DestinationSettings destinationSettings;
        private DashIsoEncryptionSettings encryption;
        private Integer fragmentLength;
        private String hbbtvCompliance;
        private Integer minBufferTime;
        private String segmentControl;
        private Integer segmentLength;
        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoGroupSettings model) {
            this.baseUrl(model.baseUrl);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.hbbtvCompliance(model.hbbtvCompliance);
            this.minBufferTime(model.minBufferTime);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final DashIsoEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashIsoEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashIsoEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getHbbtvComplianceAsString() {
            return this.hbbtvCompliance;
        }

        @Override
        public final Builder hbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
            return this;
        }

        @Override
        public final Builder hbbtvCompliance(DashIsoHbbtvCompliance hbbtvCompliance) {
            this.hbbtvCompliance(hbbtvCompliance == null ? null : hbbtvCompliance.toString());
            return this;
        }

        public final void setHbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final String getSegmentControlAsString() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(DashIsoSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getWriteSegmentTimelineInRepresentationAsString() {
            return this.writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        public DashIsoGroupSettings build() {
            return new DashIsoGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashIsoGroupSettings> {
        public Builder baseUrl(String var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(DashIsoEncryptionSettings var1);

        default public Builder encryption(Consumer<DashIsoEncryptionSettings.Builder> encryption) {
            return this.encryption((DashIsoEncryptionSettings)((DashIsoEncryptionSettings.Builder)DashIsoEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder hbbtvCompliance(String var1);

        public Builder hbbtvCompliance(DashIsoHbbtvCompliance var1);

        public Builder minBufferTime(Integer var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(DashIsoSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder writeSegmentTimelineInRepresentation(String var1);

        public Builder writeSegmentTimelineInRepresentation(DashIsoWriteSegmentTimelineInRepresentation var1);
    }
}

