/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationAlgorithmControl;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationLoudnessLogging;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationPeakCalculation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioNormalizationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioNormalizationSettings> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::algorithmAsString)).setter(AudioNormalizationSettings.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> ALGORITHM_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::algorithmControlAsString)).setter(AudioNormalizationSettings.setter(Builder::algorithmControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmControl").build()}).build();
    private static final SdkField<Integer> CORRECTION_GATE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::correctionGateLevel)).setter(AudioNormalizationSettings.setter(Builder::correctionGateLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("correctionGateLevel").build()}).build();
    private static final SdkField<String> LOUDNESS_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::loudnessLoggingAsString)).setter(AudioNormalizationSettings.setter(Builder::loudnessLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loudnessLogging").build()}).build();
    private static final SdkField<String> PEAK_CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::peakCalculationAsString)).setter(AudioNormalizationSettings.setter(Builder::peakCalculation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peakCalculation").build()}).build();
    private static final SdkField<Double> TARGET_LKFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::targetLkfs)).setter(AudioNormalizationSettings.setter(Builder::targetLkfs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLkfs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, ALGORITHM_CONTROL_FIELD, CORRECTION_GATE_LEVEL_FIELD, LOUDNESS_LOGGING_FIELD, PEAK_CALCULATION_FIELD, TARGET_LKFS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String algorithmControl;
    private final Integer correctionGateLevel;
    private final String loudnessLogging;
    private final String peakCalculation;
    private final Double targetLkfs;

    private AudioNormalizationSettings(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.algorithmControl = builder.algorithmControl;
        this.correctionGateLevel = builder.correctionGateLevel;
        this.loudnessLogging = builder.loudnessLogging;
        this.peakCalculation = builder.peakCalculation;
        this.targetLkfs = builder.targetLkfs;
    }

    public AudioNormalizationAlgorithm algorithm() {
        return AudioNormalizationAlgorithm.fromValue(this.algorithm);
    }

    public String algorithmAsString() {
        return this.algorithm;
    }

    public AudioNormalizationAlgorithmControl algorithmControl() {
        return AudioNormalizationAlgorithmControl.fromValue(this.algorithmControl);
    }

    public String algorithmControlAsString() {
        return this.algorithmControl;
    }

    public Integer correctionGateLevel() {
        return this.correctionGateLevel;
    }

    public AudioNormalizationLoudnessLogging loudnessLogging() {
        return AudioNormalizationLoudnessLogging.fromValue(this.loudnessLogging);
    }

    public String loudnessLoggingAsString() {
        return this.loudnessLogging;
    }

    public AudioNormalizationPeakCalculation peakCalculation() {
        return AudioNormalizationPeakCalculation.fromValue(this.peakCalculation);
    }

    public String peakCalculationAsString() {
        return this.peakCalculation;
    }

    public Double targetLkfs() {
        return this.targetLkfs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.correctionGateLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.loudnessLoggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.peakCalculationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLkfs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioNormalizationSettings)) {
            return false;
        }
        AudioNormalizationSettings other = (AudioNormalizationSettings)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.algorithmControlAsString(), other.algorithmControlAsString()) && Objects.equals(this.correctionGateLevel(), other.correctionGateLevel()) && Objects.equals(this.loudnessLoggingAsString(), other.loudnessLoggingAsString()) && Objects.equals(this.peakCalculationAsString(), other.peakCalculationAsString()) && Objects.equals(this.targetLkfs(), other.targetLkfs());
    }

    public String toString() {
        return ToString.builder((String)"AudioNormalizationSettings").add("Algorithm", (Object)this.algorithmAsString()).add("AlgorithmControl", (Object)this.algorithmControlAsString()).add("CorrectionGateLevel", (Object)this.correctionGateLevel()).add("LoudnessLogging", (Object)this.loudnessLoggingAsString()).add("PeakCalculation", (Object)this.peakCalculationAsString()).add("TargetLkfs", (Object)this.targetLkfs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "AlgorithmControl": {
                return Optional.ofNullable(clazz.cast(this.algorithmControlAsString()));
            }
            case "CorrectionGateLevel": {
                return Optional.ofNullable(clazz.cast(this.correctionGateLevel()));
            }
            case "LoudnessLogging": {
                return Optional.ofNullable(clazz.cast(this.loudnessLoggingAsString()));
            }
            case "PeakCalculation": {
                return Optional.ofNullable(clazz.cast(this.peakCalculationAsString()));
            }
            case "TargetLkfs": {
                return Optional.ofNullable(clazz.cast(this.targetLkfs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioNormalizationSettings, T> g) {
        return obj -> g.apply((AudioNormalizationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String algorithmControl;
        private Integer correctionGateLevel;
        private String loudnessLogging;
        private String peakCalculation;
        private Double targetLkfs;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioNormalizationSettings model) {
            this.algorithm(model.algorithm);
            this.algorithmControl(model.algorithmControl);
            this.correctionGateLevel(model.correctionGateLevel);
            this.loudnessLogging(model.loudnessLogging);
            this.peakCalculation(model.peakCalculation);
            this.targetLkfs(model.targetLkfs);
        }

        public final String getAlgorithmAsString() {
            return this.algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(AudioNormalizationAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getAlgorithmControlAsString() {
            return this.algorithmControl;
        }

        @Override
        public final Builder algorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
            return this;
        }

        @Override
        public final Builder algorithmControl(AudioNormalizationAlgorithmControl algorithmControl) {
            this.algorithmControl(algorithmControl == null ? null : algorithmControl.toString());
            return this;
        }

        public final void setAlgorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
        }

        public final Integer getCorrectionGateLevel() {
            return this.correctionGateLevel;
        }

        @Override
        public final Builder correctionGateLevel(Integer correctionGateLevel) {
            this.correctionGateLevel = correctionGateLevel;
            return this;
        }

        public final void setCorrectionGateLevel(Integer correctionGateLevel) {
            this.correctionGateLevel = correctionGateLevel;
        }

        public final String getLoudnessLoggingAsString() {
            return this.loudnessLogging;
        }

        @Override
        public final Builder loudnessLogging(String loudnessLogging) {
            this.loudnessLogging = loudnessLogging;
            return this;
        }

        @Override
        public final Builder loudnessLogging(AudioNormalizationLoudnessLogging loudnessLogging) {
            this.loudnessLogging(loudnessLogging == null ? null : loudnessLogging.toString());
            return this;
        }

        public final void setLoudnessLogging(String loudnessLogging) {
            this.loudnessLogging = loudnessLogging;
        }

        public final String getPeakCalculationAsString() {
            return this.peakCalculation;
        }

        @Override
        public final Builder peakCalculation(String peakCalculation) {
            this.peakCalculation = peakCalculation;
            return this;
        }

        @Override
        public final Builder peakCalculation(AudioNormalizationPeakCalculation peakCalculation) {
            this.peakCalculation(peakCalculation == null ? null : peakCalculation.toString());
            return this;
        }

        public final void setPeakCalculation(String peakCalculation) {
            this.peakCalculation = peakCalculation;
        }

        public final Double getTargetLkfs() {
            return this.targetLkfs;
        }

        @Override
        public final Builder targetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
            return this;
        }

        public final void setTargetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
        }

        public AudioNormalizationSettings build() {
            return new AudioNormalizationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioNormalizationSettings> {
        public Builder algorithm(String var1);

        public Builder algorithm(AudioNormalizationAlgorithm var1);

        public Builder algorithmControl(String var1);

        public Builder algorithmControl(AudioNormalizationAlgorithmControl var1);

        public Builder correctionGateLevel(Integer var1);

        public Builder loudnessLogging(String var1);

        public Builder loudnessLogging(AudioNormalizationLoudnessLogging var1);

        public Builder peakCalculation(String var1);

        public Builder peakCalculation(AudioNormalizationPeakCalculation var1);

        public Builder targetLkfs(Double var1);
    }
}

