/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfGrantEntitlementRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantFlowEntitlementsRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, GrantFlowEntitlementsRequest> {
    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GrantFlowEntitlementsRequest.getter(GrantFlowEntitlementsRequest::entitlements)).setter(GrantFlowEntitlementsRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrantEntitlementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GrantFlowEntitlementsRequest.getter(GrantFlowEntitlementsRequest::flowArn)).setter(GrantFlowEntitlementsRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD, FLOW_ARN_FIELD));
    private final List<GrantEntitlementRequest> entitlements;
    private final String flowArn;

    private GrantFlowEntitlementsRequest(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
    }

    public List<GrantEntitlementRequest> entitlements() {
        return this.entitlements;
    }

    public String flowArn() {
        return this.flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlements());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantFlowEntitlementsRequest)) {
            return false;
        }
        GrantFlowEntitlementsRequest other = (GrantFlowEntitlementsRequest)((Object)obj);
        return Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.flowArn(), other.flowArn());
    }

    public String toString() {
        return ToString.builder((String)"GrantFlowEntitlementsRequest").add("Entitlements", this.entitlements()).add("FlowArn", (Object)this.flowArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantFlowEntitlementsRequest, T> g) {
        return obj -> g.apply((GrantFlowEntitlementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantFlowEntitlementsRequest model) {
            super(model);
            this.entitlements(model.entitlements);
            this.flowArn(model.flowArn);
        }

        public final Collection<GrantEntitlementRequest.Builder> getEntitlements() {
            return this.entitlements != null ? (Collection)this.entitlements.stream().map(GrantEntitlementRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (GrantEntitlementRequest)((GrantEntitlementRequest.Builder)GrantEntitlementRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GrantFlowEntitlementsRequest build() {
            return new GrantFlowEntitlementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GrantFlowEntitlementsRequest> {
        public Builder entitlements(Collection<GrantEntitlementRequest> var1);

        public Builder entitlements(GrantEntitlementRequest ... var1);

        public Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... var1);

        public Builder flowArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

