/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ConfirmationStatus;
import software.amazon.awssdk.services.managedblockchainquery.model.ExecutionStatus;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transaction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transaction> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(Transaction.getter(Transaction::networkAsString)).setter(Transaction.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<String> BLOCK_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockHash").getter(Transaction.getter(Transaction::blockHash)).setter(Transaction.setter(Builder::blockHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockHash").build()}).build();
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionHash").getter(Transaction.getter(Transaction::transactionHash)).setter(Transaction.setter(Builder::transactionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()}).build();
    private static final SdkField<String> BLOCK_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockNumber").getter(Transaction.getter(Transaction::blockNumber)).setter(Transaction.setter(Builder::blockNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockNumber").build()}).build();
    private static final SdkField<Instant> TRANSACTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("transactionTimestamp").getter(Transaction.getter(Transaction::transactionTimestamp)).setter(Transaction.setter(Builder::transactionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionTimestamp").build()}).build();
    private static final SdkField<Long> TRANSACTION_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("transactionIndex").getter(Transaction.getter(Transaction::transactionIndex)).setter(Transaction.setter(Builder::transactionIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionIndex").build()}).build();
    private static final SdkField<Long> NUMBER_OF_TRANSACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfTransactions").getter(Transaction.getter(Transaction::numberOfTransactions)).setter(Transaction.setter(Builder::numberOfTransactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTransactions").build()}).build();
    private static final SdkField<String> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("to").getter(Transaction.getter(Transaction::to)).setter(Transaction.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("from").getter(Transaction.getter(Transaction::from)).setter(Transaction.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contractAddress").getter(Transaction.getter(Transaction::contractAddress)).setter(Transaction.setter(Builder::contractAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()}).build();
    private static final SdkField<String> GAS_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gasUsed").getter(Transaction.getter(Transaction::gasUsed)).setter(Transaction.setter(Builder::gasUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gasUsed").build()}).build();
    private static final SdkField<String> CUMULATIVE_GAS_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cumulativeGasUsed").getter(Transaction.getter(Transaction::cumulativeGasUsed)).setter(Transaction.setter(Builder::cumulativeGasUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cumulativeGasUsed").build()}).build();
    private static final SdkField<String> EFFECTIVE_GAS_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effectiveGasPrice").getter(Transaction.getter(Transaction::effectiveGasPrice)).setter(Transaction.setter(Builder::effectiveGasPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveGasPrice").build()}).build();
    private static final SdkField<Integer> SIGNATUREV_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("signatureV").getter(Transaction.getter(Transaction::signatureV)).setter(Transaction.setter(Builder::signatureV)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureV").build()}).build();
    private static final SdkField<String> SIGNATURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureR").getter(Transaction.getter(Transaction::signatureR)).setter(Transaction.setter(Builder::signatureR)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureR").build()}).build();
    private static final SdkField<String> SIGNATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureS").getter(Transaction.getter(Transaction::signatureS)).setter(Transaction.setter(Builder::signatureS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureS").build()}).build();
    private static final SdkField<String> TRANSACTION_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionFee").getter(Transaction.getter(Transaction::transactionFee)).setter(Transaction.setter(Builder::transactionFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionFee").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(Transaction.getter(Transaction::transactionId)).setter(Transaction.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationStatus").getter(Transaction.getter(Transaction::confirmationStatusAsString)).setter(Transaction.setter(Builder::confirmationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(Transaction.getter(Transaction::executionStatusAsString)).setter(Transaction.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD, BLOCK_HASH_FIELD, TRANSACTION_HASH_FIELD, BLOCK_NUMBER_FIELD, TRANSACTION_TIMESTAMP_FIELD, TRANSACTION_INDEX_FIELD, NUMBER_OF_TRANSACTIONS_FIELD, TO_FIELD, FROM_FIELD, CONTRACT_ADDRESS_FIELD, GAS_USED_FIELD, CUMULATIVE_GAS_USED_FIELD, EFFECTIVE_GAS_PRICE_FIELD, SIGNATUREV_FIELD, SIGNATURER_FIELD, SIGNATURES_FIELD, TRANSACTION_FEE_FIELD, TRANSACTION_ID_FIELD, CONFIRMATION_STATUS_FIELD, EXECUTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Transaction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String network;
    private final String blockHash;
    private final String transactionHash;
    private final String blockNumber;
    private final Instant transactionTimestamp;
    private final Long transactionIndex;
    private final Long numberOfTransactions;
    private final String to;
    private final String from;
    private final String contractAddress;
    private final String gasUsed;
    private final String cumulativeGasUsed;
    private final String effectiveGasPrice;
    private final Integer signatureV;
    private final String signatureR;
    private final String signatureS;
    private final String transactionFee;
    private final String transactionId;
    private final String confirmationStatus;
    private final String executionStatus;

    private Transaction(BuilderImpl builder) {
        this.network = builder.network;
        this.blockHash = builder.blockHash;
        this.transactionHash = builder.transactionHash;
        this.blockNumber = builder.blockNumber;
        this.transactionTimestamp = builder.transactionTimestamp;
        this.transactionIndex = builder.transactionIndex;
        this.numberOfTransactions = builder.numberOfTransactions;
        this.to = builder.to;
        this.from = builder.from;
        this.contractAddress = builder.contractAddress;
        this.gasUsed = builder.gasUsed;
        this.cumulativeGasUsed = builder.cumulativeGasUsed;
        this.effectiveGasPrice = builder.effectiveGasPrice;
        this.signatureV = builder.signatureV;
        this.signatureR = builder.signatureR;
        this.signatureS = builder.signatureS;
        this.transactionFee = builder.transactionFee;
        this.transactionId = builder.transactionId;
        this.confirmationStatus = builder.confirmationStatus;
        this.executionStatus = builder.executionStatus;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final String blockHash() {
        return this.blockHash;
    }

    public final String transactionHash() {
        return this.transactionHash;
    }

    public final String blockNumber() {
        return this.blockNumber;
    }

    public final Instant transactionTimestamp() {
        return this.transactionTimestamp;
    }

    public final Long transactionIndex() {
        return this.transactionIndex;
    }

    public final Long numberOfTransactions() {
        return this.numberOfTransactions;
    }

    public final String to() {
        return this.to;
    }

    public final String from() {
        return this.from;
    }

    public final String contractAddress() {
        return this.contractAddress;
    }

    public final String gasUsed() {
        return this.gasUsed;
    }

    public final String cumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public final String effectiveGasPrice() {
        return this.effectiveGasPrice;
    }

    public final Integer signatureV() {
        return this.signatureV;
    }

    public final String signatureR() {
        return this.signatureR;
    }

    public final String signatureS() {
        return this.signatureS;
    }

    public final String transactionFee() {
        return this.transactionFee;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(this.confirmationStatus);
    }

    public final String confirmationStatusAsString() {
        return this.confirmationStatus;
    }

    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTransactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.contractAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.gasUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.cumulativeGasUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveGasPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureV());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureR());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureS());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.blockHash(), other.blockHash()) && Objects.equals(this.transactionHash(), other.transactionHash()) && Objects.equals(this.blockNumber(), other.blockNumber()) && Objects.equals(this.transactionTimestamp(), other.transactionTimestamp()) && Objects.equals(this.transactionIndex(), other.transactionIndex()) && Objects.equals(this.numberOfTransactions(), other.numberOfTransactions()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.contractAddress(), other.contractAddress()) && Objects.equals(this.gasUsed(), other.gasUsed()) && Objects.equals(this.cumulativeGasUsed(), other.cumulativeGasUsed()) && Objects.equals(this.effectiveGasPrice(), other.effectiveGasPrice()) && Objects.equals(this.signatureV(), other.signatureV()) && Objects.equals(this.signatureR(), other.signatureR()) && Objects.equals(this.signatureS(), other.signatureS()) && Objects.equals(this.transactionFee(), other.transactionFee()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.confirmationStatusAsString(), other.confirmationStatusAsString()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Transaction").add("Network", (Object)this.networkAsString()).add("BlockHash", (Object)this.blockHash()).add("TransactionHash", (Object)this.transactionHash()).add("BlockNumber", (Object)this.blockNumber()).add("TransactionTimestamp", (Object)this.transactionTimestamp()).add("TransactionIndex", (Object)this.transactionIndex()).add("NumberOfTransactions", (Object)this.numberOfTransactions()).add("To", (Object)this.to()).add("From", (Object)this.from()).add("ContractAddress", (Object)this.contractAddress()).add("GasUsed", (Object)this.gasUsed()).add("CumulativeGasUsed", (Object)this.cumulativeGasUsed()).add("EffectiveGasPrice", (Object)this.effectiveGasPrice()).add("SignatureV", (Object)this.signatureV()).add("SignatureR", (Object)this.signatureR()).add("SignatureS", (Object)this.signatureS()).add("TransactionFee", (Object)this.transactionFee()).add("TransactionId", (Object)this.transactionId()).add("ConfirmationStatus", (Object)this.confirmationStatusAsString()).add("ExecutionStatus", (Object)this.executionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "blockHash": {
                return Optional.ofNullable(clazz.cast(this.blockHash()));
            }
            case "transactionHash": {
                return Optional.ofNullable(clazz.cast(this.transactionHash()));
            }
            case "blockNumber": {
                return Optional.ofNullable(clazz.cast(this.blockNumber()));
            }
            case "transactionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.transactionTimestamp()));
            }
            case "transactionIndex": {
                return Optional.ofNullable(clazz.cast(this.transactionIndex()));
            }
            case "numberOfTransactions": {
                return Optional.ofNullable(clazz.cast(this.numberOfTransactions()));
            }
            case "to": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "contractAddress": {
                return Optional.ofNullable(clazz.cast(this.contractAddress()));
            }
            case "gasUsed": {
                return Optional.ofNullable(clazz.cast(this.gasUsed()));
            }
            case "cumulativeGasUsed": {
                return Optional.ofNullable(clazz.cast(this.cumulativeGasUsed()));
            }
            case "effectiveGasPrice": {
                return Optional.ofNullable(clazz.cast(this.effectiveGasPrice()));
            }
            case "signatureV": {
                return Optional.ofNullable(clazz.cast(this.signatureV()));
            }
            case "signatureR": {
                return Optional.ofNullable(clazz.cast(this.signatureR()));
            }
            case "signatureS": {
                return Optional.ofNullable(clazz.cast(this.signatureS()));
            }
            case "transactionFee": {
                return Optional.ofNullable(clazz.cast(this.transactionFee()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "confirmationStatus": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusAsString()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("network", NETWORK_FIELD);
        map.put("blockHash", BLOCK_HASH_FIELD);
        map.put("transactionHash", TRANSACTION_HASH_FIELD);
        map.put("blockNumber", BLOCK_NUMBER_FIELD);
        map.put("transactionTimestamp", TRANSACTION_TIMESTAMP_FIELD);
        map.put("transactionIndex", TRANSACTION_INDEX_FIELD);
        map.put("numberOfTransactions", NUMBER_OF_TRANSACTIONS_FIELD);
        map.put("to", TO_FIELD);
        map.put("from", FROM_FIELD);
        map.put("contractAddress", CONTRACT_ADDRESS_FIELD);
        map.put("gasUsed", GAS_USED_FIELD);
        map.put("cumulativeGasUsed", CUMULATIVE_GAS_USED_FIELD);
        map.put("effectiveGasPrice", EFFECTIVE_GAS_PRICE_FIELD);
        map.put("signatureV", SIGNATUREV_FIELD);
        map.put("signatureR", SIGNATURER_FIELD);
        map.put("signatureS", SIGNATURES_FIELD);
        map.put("transactionFee", TRANSACTION_FEE_FIELD);
        map.put("transactionId", TRANSACTION_ID_FIELD);
        map.put("confirmationStatus", CONFIRMATION_STATUS_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transaction, T> g) {
        return obj -> g.apply((Transaction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String network;
        private String blockHash;
        private String transactionHash;
        private String blockNumber;
        private Instant transactionTimestamp;
        private Long transactionIndex;
        private Long numberOfTransactions;
        private String to;
        private String from;
        private String contractAddress;
        private String gasUsed;
        private String cumulativeGasUsed;
        private String effectiveGasPrice;
        private Integer signatureV;
        private String signatureR;
        private String signatureS;
        private String transactionFee;
        private String transactionId;
        private String confirmationStatus;
        private String executionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Transaction model) {
            this.network(model.network);
            this.blockHash(model.blockHash);
            this.transactionHash(model.transactionHash);
            this.blockNumber(model.blockNumber);
            this.transactionTimestamp(model.transactionTimestamp);
            this.transactionIndex(model.transactionIndex);
            this.numberOfTransactions(model.numberOfTransactions);
            this.to(model.to);
            this.from(model.from);
            this.contractAddress(model.contractAddress);
            this.gasUsed(model.gasUsed);
            this.cumulativeGasUsed(model.cumulativeGasUsed);
            this.effectiveGasPrice(model.effectiveGasPrice);
            this.signatureV(model.signatureV);
            this.signatureR(model.signatureR);
            this.signatureS(model.signatureS);
            this.transactionFee(model.transactionFee);
            this.transactionId(model.transactionId);
            this.confirmationStatus(model.confirmationStatus);
            this.executionStatus(model.executionStatus);
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getBlockHash() {
            return this.blockHash;
        }

        public final void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        @Override
        public final Builder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public final String getTransactionHash() {
            return this.transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getBlockNumber() {
            return this.blockNumber;
        }

        public final void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        @Override
        public final Builder blockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public final Instant getTransactionTimestamp() {
            return this.transactionTimestamp;
        }

        public final void setTransactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
        }

        @Override
        public final Builder transactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
            return this;
        }

        public final Long getTransactionIndex() {
            return this.transactionIndex;
        }

        public final void setTransactionIndex(Long transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        @Override
        public final Builder transactionIndex(Long transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public final Long getNumberOfTransactions() {
            return this.numberOfTransactions;
        }

        public final void setNumberOfTransactions(Long numberOfTransactions) {
            this.numberOfTransactions = numberOfTransactions;
        }

        @Override
        public final Builder numberOfTransactions(Long numberOfTransactions) {
            this.numberOfTransactions = numberOfTransactions;
            return this;
        }

        public final String getTo() {
            return this.to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getContractAddress() {
            return this.contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public final String getGasUsed() {
            return this.gasUsed;
        }

        public final void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        @Override
        public final Builder gasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public final String getCumulativeGasUsed() {
            return this.cumulativeGasUsed;
        }

        public final void setCumulativeGasUsed(String cumulativeGasUsed) {
            this.cumulativeGasUsed = cumulativeGasUsed;
        }

        @Override
        public final Builder cumulativeGasUsed(String cumulativeGasUsed) {
            this.cumulativeGasUsed = cumulativeGasUsed;
            return this;
        }

        public final String getEffectiveGasPrice() {
            return this.effectiveGasPrice;
        }

        public final void setEffectiveGasPrice(String effectiveGasPrice) {
            this.effectiveGasPrice = effectiveGasPrice;
        }

        @Override
        public final Builder effectiveGasPrice(String effectiveGasPrice) {
            this.effectiveGasPrice = effectiveGasPrice;
            return this;
        }

        public final Integer getSignatureV() {
            return this.signatureV;
        }

        public final void setSignatureV(Integer signatureV) {
            this.signatureV = signatureV;
        }

        @Override
        public final Builder signatureV(Integer signatureV) {
            this.signatureV = signatureV;
            return this;
        }

        public final String getSignatureR() {
            return this.signatureR;
        }

        public final void setSignatureR(String signatureR) {
            this.signatureR = signatureR;
        }

        @Override
        public final Builder signatureR(String signatureR) {
            this.signatureR = signatureR;
            return this;
        }

        public final String getSignatureS() {
            return this.signatureS;
        }

        public final void setSignatureS(String signatureS) {
            this.signatureS = signatureS;
        }

        @Override
        public final Builder signatureS(String signatureS) {
            this.signatureS = signatureS;
            return this;
        }

        public final String getTransactionFee() {
            return this.transactionFee;
        }

        public final void setTransactionFee(String transactionFee) {
            this.transactionFee = transactionFee;
        }

        @Override
        public final Builder transactionFee(String transactionFee) {
            this.transactionFee = transactionFee;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getConfirmationStatus() {
            return this.confirmationStatus;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public Transaction build() {
            return new Transaction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transaction> {
        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder blockHash(String var1);

        public Builder transactionHash(String var1);

        public Builder blockNumber(String var1);

        public Builder transactionTimestamp(Instant var1);

        public Builder transactionIndex(Long var1);

        public Builder numberOfTransactions(Long var1);

        public Builder to(String var1);

        public Builder from(String var1);

        public Builder contractAddress(String var1);

        public Builder gasUsed(String var1);

        public Builder cumulativeGasUsed(String var1);

        public Builder effectiveGasPrice(String var1);

        public Builder signatureV(Integer var1);

        public Builder signatureR(String var1);

        public Builder signatureS(String var1);

        public Builder transactionFee(String var1);

        public Builder transactionId(String var1);

        public Builder confirmationStatus(String var1);

        public Builder confirmationStatus(ConfirmationStatus var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);
    }
}

