/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.model.AccessDeniedException;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.IllegalActionException;
import software.amazon.awssdk.services.managedblockchain.model.InternalServiceErrorException;
import software.amazon.awssdk.services.managedblockchain.model.InvalidRequestException;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainException;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationResponse;
import software.amazon.awssdk.services.managedblockchain.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceNotReadyException;
import software.amazon.awssdk.services.managedblockchain.model.ThrottlingException;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalResponse;
import software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable;
import software.amazon.awssdk.services.managedblockchain.transform.CreateMemberRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.CreateNodeRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.CreateProposalRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.DeleteMemberRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.DeleteNodeRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.GetNetworkRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.GetNodeRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.GetProposalRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListProposalVotesRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.ListProposalsRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.RejectInvitationRequestMarshaller;
import software.amazon.awssdk.services.managedblockchain.transform.VoteOnProposalRequestMarshaller;

@SdkInternalApi
final class DefaultManagedBlockchainClient
implements ManagedBlockchainClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultManagedBlockchainClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "managedblockchain";
    }

    @Override
    public CreateMemberResponse createMember(CreateMemberRequest createMemberRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceNotReadyException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMemberRequest).withMarshaller((Marshaller)new CreateMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws InvalidRequestException, AccessDeniedException, ResourceAlreadyExistsException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNetworkRequest).withMarshaller((Marshaller)new CreateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateNodeResponse createNode(CreateNodeRequest createNodeRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceNotReadyException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNodeRequest).withMarshaller((Marshaller)new CreateNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProposalResponse createProposal(CreateProposalRequest createProposalRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProposalResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProposal").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProposalRequest).withMarshaller((Marshaller)new CreateProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteMemberResponse deleteMember(DeleteMemberRequest deleteMemberRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMemberRequest).withMarshaller((Marshaller)new DeleteMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteNodeResponse deleteNode(DeleteNodeRequest deleteNodeRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNodeRequest).withMarshaller((Marshaller)new DeleteNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMemberRequest).withMarshaller((Marshaller)new GetMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetNetworkResponse getNetwork(GetNetworkRequest getNetworkRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNetworkRequest).withMarshaller((Marshaller)new GetNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetNodeResponse getNode(GetNodeRequest getNodeRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNodeRequest).withMarshaller((Marshaller)new GetNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetProposalResponse getProposal(GetProposalRequest getProposalRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProposalResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProposal").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProposalRequest).withMarshaller((Marshaller)new GetProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvitationsRequest).withMarshaller((Marshaller)new ListInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListInvitationsIterable(this, this.applyPaginatorUserAgent(listInvitationsRequest));
    }

    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest).withMarshaller((Marshaller)new ListMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListMembersIterable(this, this.applyPaginatorUserAgent(listMembersRequest));
    }

    @Override
    public ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNetworksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListNetworksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNetworks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNetworksRequest).withMarshaller((Marshaller)new ListNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListNetworksIterable listNetworksPaginator(ListNetworksRequest listNetworksRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListNetworksIterable(this, this.applyPaginatorUserAgent(listNetworksRequest));
    }

    @Override
    public ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNodesRequest).withMarshaller((Marshaller)new ListNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListNodesIterable(this, this.applyPaginatorUserAgent(listNodesRequest));
    }

    @Override
    public ListProposalVotesResponse listProposalVotes(ListProposalVotesRequest listProposalVotesRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProposalVotesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProposalVotesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProposalVotes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProposalVotesRequest).withMarshaller((Marshaller)new ListProposalVotesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProposalVotesIterable listProposalVotesPaginator(ListProposalVotesRequest listProposalVotesRequest) throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListProposalVotesIterable(this, this.applyPaginatorUserAgent(listProposalVotesRequest));
    }

    @Override
    public ListProposalsResponse listProposals(ListProposalsRequest listProposalsRequest) throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProposalsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProposalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProposals").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProposalsRequest).withMarshaller((Marshaller)new ListProposalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProposalsIterable listProposalsPaginator(ListProposalsRequest listProposalsRequest) throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListProposalsIterable(this, this.applyPaginatorUserAgent(listProposalsRequest));
    }

    @Override
    public RejectInvitationResponse rejectInvitation(RejectInvitationRequest rejectInvitationRequest) throws InvalidRequestException, IllegalActionException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RejectInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectInvitationRequest).withMarshaller((Marshaller)new RejectInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public VoteOnProposalResponse voteOnProposal(VoteOnProposalRequest voteOnProposalRequest) throws InvalidRequestException, IllegalActionException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VoteOnProposalResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (VoteOnProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VoteOnProposal").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)voteOnProposalRequest).withMarshaller((Marshaller)new VoteOnProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ManagedBlockchainException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").exceptionBuilderSupplier(ResourceNotReadyException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalActionException").exceptionBuilderSupplier(IllegalActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ManagedBlockchainRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.7.12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ManagedBlockchainRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

