/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainResponse;
import software.amazon.awssdk.services.managedblockchain.model.ProposalVoteListCopier;
import software.amazon.awssdk.services.managedblockchain.model.VoteSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProposalVotesResponse
extends ManagedBlockchainResponse
implements ToCopyableBuilder<Builder, ListProposalVotesResponse> {
    private static final SdkField<List<VoteSummary>> PROPOSAL_VOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProposalVotesResponse.getter(ListProposalVotesResponse::proposalVotes)).setter(ListProposalVotesResponse.setter(Builder::proposalVotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalVotes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProposalVotesResponse.getter(ListProposalVotesResponse::nextToken)).setter(ListProposalVotesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_VOTES_FIELD, NEXT_TOKEN_FIELD));
    private final List<VoteSummary> proposalVotes;
    private final String nextToken;

    private ListProposalVotesResponse(BuilderImpl builder) {
        super(builder);
        this.proposalVotes = builder.proposalVotes;
        this.nextToken = builder.nextToken;
    }

    public List<VoteSummary> proposalVotes() {
        return this.proposalVotes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalVotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProposalVotesResponse)) {
            return false;
        }
        ListProposalVotesResponse other = (ListProposalVotesResponse)((Object)obj);
        return Objects.equals(this.proposalVotes(), other.proposalVotes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProposalVotesResponse").add("ProposalVotes", this.proposalVotes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProposalVotes": {
                return Optional.ofNullable(clazz.cast(this.proposalVotes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProposalVotesResponse, T> g) {
        return obj -> g.apply((ListProposalVotesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainResponse.BuilderImpl
    implements Builder {
        private List<VoteSummary> proposalVotes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProposalVotesResponse model) {
            super(model);
            this.proposalVotes(model.proposalVotes);
            this.nextToken(model.nextToken);
        }

        public final Collection<VoteSummary.Builder> getProposalVotes() {
            return this.proposalVotes != null ? (Collection)this.proposalVotes.stream().map(VoteSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder proposalVotes(Collection<VoteSummary> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copy(proposalVotes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(VoteSummary ... proposalVotes) {
            this.proposalVotes(Arrays.asList(proposalVotes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(Consumer<VoteSummary.Builder> ... proposalVotes) {
            this.proposalVotes(Stream.of(proposalVotes).map(c -> (VoteSummary)((VoteSummary.Builder)VoteSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProposalVotes(Collection<VoteSummary.BuilderImpl> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copyFromBuilder(proposalVotes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProposalVotesResponse build() {
            return new ListProposalVotesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProposalVotesResponse> {
        public Builder proposalVotes(Collection<VoteSummary> var1);

        public Builder proposalVotes(VoteSummary ... var1);

        public Builder proposalVotes(Consumer<VoteSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

