/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes;
import software.amazon.awssdk.services.managedblockchain.model.NodeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::networkId)).setter(Node.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::memberId)).setter(Node.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::id)).setter(Node.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::instanceType)).setter(Node.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::availabilityZone)).setter(Node.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<NodeFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Node.getter(Node::frameworkAttributes)).setter(Node.setter(Builder::frameworkAttributes)).constructor(NodeFrameworkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Node.getter(Node::statusAsString)).setter(Node.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Node.getter(Node::creationDate)).setter(Node.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, MEMBER_ID_FIELD, ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, FRAMEWORK_ATTRIBUTES_FIELD, STATUS_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkId;
    private final String memberId;
    private final String id;
    private final String instanceType;
    private final String availabilityZone;
    private final NodeFrameworkAttributes frameworkAttributes;
    private final String status;
    private final Instant creationDate;

    private Node(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.id = builder.id;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    public String networkId() {
        return this.networkId;
    }

    public String memberId() {
        return this.memberId;
    }

    public String id() {
        return this.id;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public NodeFrameworkAttributes frameworkAttributes() {
        return this.frameworkAttributes;
    }

    public NodeStatus status() {
        return NodeStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.frameworkAttributes(), other.frameworkAttributes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"Node").add("NetworkId", (Object)this.networkId()).add("MemberId", (Object)this.memberId()).add("Id", (Object)this.id()).add("InstanceType", (Object)this.instanceType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("FrameworkAttributes", (Object)this.frameworkAttributes()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "FrameworkAttributes": {
                return Optional.ofNullable(clazz.cast(this.frameworkAttributes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkId;
        private String memberId;
        private String id;
        private String instanceType;
        private String availabilityZone;
        private NodeFrameworkAttributes frameworkAttributes;
        private String status;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.networkId(model.networkId);
            this.memberId(model.memberId);
            this.id(model.id);
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.frameworkAttributes(model.frameworkAttributes);
            this.status(model.status);
            this.creationDate(model.creationDate);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final NodeFrameworkAttributes.Builder getFrameworkAttributes() {
            return this.frameworkAttributes != null ? this.frameworkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder frameworkAttributes(NodeFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final void setFrameworkAttributes(NodeFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder networkId(String var1);

        public Builder memberId(String var1);

        public Builder id(String var1);

        public Builder instanceType(String var1);

        public Builder availabilityZone(String var1);

        public Builder frameworkAttributes(NodeFrameworkAttributes var1);

        default public Builder frameworkAttributes(Consumer<NodeFrameworkAttributes.Builder> frameworkAttributes) {
            return this.frameworkAttributes((NodeFrameworkAttributes)((NodeFrameworkAttributes.Builder)NodeFrameworkAttributes.builder().applyMutation(frameworkAttributes)).build());
        }

        public Builder status(String var1);

        public Builder status(NodeStatus var1);

        public Builder creationDate(Instant var1);
    }
}

