/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.VoteValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoteOnProposalRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, VoteOnProposalRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoteOnProposalRequest.getter(VoteOnProposalRequest::networkId)).setter(VoteOnProposalRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoteOnProposalRequest.getter(VoteOnProposalRequest::proposalId)).setter(VoteOnProposalRequest.setter(Builder::proposalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("proposalId").build()}).build();
    private static final SdkField<String> VOTER_MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoteOnProposalRequest.getter(VoteOnProposalRequest::voterMemberId)).setter(VoteOnProposalRequest.setter(Builder::voterMemberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoterMemberId").build()}).build();
    private static final SdkField<String> VOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VoteOnProposalRequest.getter(VoteOnProposalRequest::voteAsString)).setter(VoteOnProposalRequest.setter(Builder::vote)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vote").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, PROPOSAL_ID_FIELD, VOTER_MEMBER_ID_FIELD, VOTE_FIELD));
    private final String networkId;
    private final String proposalId;
    private final String voterMemberId;
    private final String vote;

    private VoteOnProposalRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.proposalId = builder.proposalId;
        this.voterMemberId = builder.voterMemberId;
        this.vote = builder.vote;
    }

    public String networkId() {
        return this.networkId;
    }

    public String proposalId() {
        return this.proposalId;
    }

    public String voterMemberId() {
        return this.voterMemberId;
    }

    public VoteValue vote() {
        return VoteValue.fromValue(this.vote);
    }

    public String voteAsString() {
        return this.vote;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voterMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voteAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoteOnProposalRequest)) {
            return false;
        }
        VoteOnProposalRequest other = (VoteOnProposalRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.proposalId(), other.proposalId()) && Objects.equals(this.voterMemberId(), other.voterMemberId()) && Objects.equals(this.voteAsString(), other.voteAsString());
    }

    public String toString() {
        return ToString.builder((String)"VoteOnProposalRequest").add("NetworkId", (Object)this.networkId()).add("ProposalId", (Object)this.proposalId()).add("VoterMemberId", (Object)this.voterMemberId()).add("Vote", (Object)this.voteAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "ProposalId": {
                return Optional.ofNullable(clazz.cast(this.proposalId()));
            }
            case "VoterMemberId": {
                return Optional.ofNullable(clazz.cast(this.voterMemberId()));
            }
            case "Vote": {
                return Optional.ofNullable(clazz.cast(this.voteAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoteOnProposalRequest, T> g) {
        return obj -> g.apply((VoteOnProposalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String proposalId;
        private String voterMemberId;
        private String vote;

        private BuilderImpl() {
        }

        private BuilderImpl(VoteOnProposalRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.proposalId(model.proposalId);
            this.voterMemberId(model.voterMemberId);
            this.vote(model.vote);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getProposalId() {
            return this.proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getVoterMemberId() {
            return this.voterMemberId;
        }

        @Override
        public final Builder voterMemberId(String voterMemberId) {
            this.voterMemberId = voterMemberId;
            return this;
        }

        public final void setVoterMemberId(String voterMemberId) {
            this.voterMemberId = voterMemberId;
        }

        public final String getVoteAsString() {
            return this.vote;
        }

        @Override
        public final Builder vote(String vote) {
            this.vote = vote;
            return this;
        }

        @Override
        public final Builder vote(VoteValue vote) {
            this.vote(vote.toString());
            return this;
        }

        public final void setVote(String vote) {
            this.vote = vote;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VoteOnProposalRequest build() {
            return new VoteOnProposalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VoteOnProposalRequest> {
        public Builder networkId(String var1);

        public Builder proposalId(String var1);

        public Builder voterMemberId(String var1);

        public Builder vote(String var1);

        public Builder vote(VoteValue var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

