/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProposalRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<CreateProposalRequest.Builder, CreateProposalRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateProposalRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(CreateProposalRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(CreateProposalRequest::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<ProposalActions> ACTIONS_FIELD = SdkField.<ProposalActions> builder(MarshallingType.SDK_POJO)
            .memberName("Actions").getter(getter(CreateProposalRequest::actions)).setter(setter(Builder::actions))
            .constructor(ProposalActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateProposalRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateProposalRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            NETWORK_ID_FIELD, MEMBER_ID_FIELD, ACTIONS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String networkId;

    private final String memberId;

    private final ProposalActions actions;

    private final String description;

    private final Map<String, String> tags;

    private CreateProposalRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.actions = builder.actions;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than one time. This identifier is required only if you make a service request
     * directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than one time. This identifier is required only if you make a
     *         service request directly using an HTTP client. It is generated automatically if you use an Amazon Web
     *         Services SDK or the CLI.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The unique identifier of the network for which the proposal is made.
     * </p>
     * 
     * @return The unique identifier of the network for which the proposal is made.
     */
    public final String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The unique identifier of the member that is creating the proposal. This identifier is especially useful for
     * identifying the member making the proposal when multiple members exist in a single Amazon Web Services account.
     * </p>
     * 
     * @return The unique identifier of the member that is creating the proposal. This identifier is especially useful
     *         for identifying the member making the proposal when multiple members exist in a single Amazon Web
     *         Services account.
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code>
     * in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also
     * contain <code>Removals</code> actions.
     * </p>
     * 
     * @return The type of actions proposed, such as inviting a member or removing a member. The types of
     *         <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with
     *         <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.
     */
    public final ProposalActions actions() {
        return actions;
    }

    /**
     * <p>
     * A description for the proposal that is visible to voting members, for example,
     * "Proposal to add Example Corp. as member."
     * </p>
     * 
     * @return A description for the proposal that is visible to voting members, for example,
     *         "Proposal to add Example Corp. as member."
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to assign to the proposal.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request
     * with an overall maximum of 50 tags allowed per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the proposal.</p>
     *         <p>
     *         Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
     *         request with an overall maximum of 50 tags allowed per resource.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     *         Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProposalRequest)) {
            return false;
        }
        CreateProposalRequest other = (CreateProposalRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(networkId(), other.networkId())
                && Objects.equals(memberId(), other.memberId()) && Objects.equals(actions(), other.actions())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProposalRequest").add("ClientRequestToken", clientRequestToken())
                .add("NetworkId", networkId()).add("MemberId", memberId()).add("Actions", actions())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProposalRequest, T> g) {
        return obj -> g.apply((CreateProposalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProposalRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than one time. This identifier is required only if you make a service
         * request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or
         * the CLI.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than one time. This identifier is required only if you make a
         *        service request directly using an HTTP client. It is generated automatically if you use an Amazon Web
         *        Services SDK or the CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The unique identifier of the network for which the proposal is made.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network for which the proposal is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The unique identifier of the member that is creating the proposal. This identifier is especially useful for
         * identifying the member making the proposal when multiple members exist in a single Amazon Web Services
         * account.
         * </p>
         * 
         * @param memberId
         *        The unique identifier of the member that is creating the proposal. This identifier is especially
         *        useful for identifying the member making the proposal when multiple members exist in a single Amazon
         *        Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The type of actions proposed, such as inviting a member or removing a member. The types of
         * <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with
         * <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.
         * </p>
         * 
         * @param actions
         *        The type of actions proposed, such as inviting a member or removing a member. The types of
         *        <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with
         *        <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ProposalActions actions);

        /**
         * <p>
         * The type of actions proposed, such as inviting a member or removing a member. The types of
         * <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with
         * <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProposalActions.Builder} avoiding the
         * need to create one manually via {@link ProposalActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProposalActions.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(ProposalActions)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link ProposalActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(ProposalActions)
         */
        default Builder actions(Consumer<ProposalActions.Builder> actions) {
            return actions(ProposalActions.builder().applyMutation(actions).build());
        }

        /**
         * <p>
         * A description for the proposal that is visible to voting members, for example,
         * "Proposal to add Example Corp. as member."
         * </p>
         * 
         * @param description
         *        A description for the proposal that is visible to voting members, for example,
         *        "Proposal to add Example Corp. as member."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags to assign to the proposal.
         * </p>
         * <p>
         * Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
         * request with an overall maximum of 50 tags allowed per resource.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
         * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the proposal.</p>
         *        <p>
         *        Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
         *        request with an overall maximum of 50 tags allowed per resource.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String networkId;

        private String memberId;

        private ProposalActions actions;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProposalRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            networkId(model.networkId);
            memberId(model.memberId);
            actions(model.actions);
            description(model.description);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getMemberId() {
            return memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final ProposalActions.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(ProposalActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(ProposalActions actions) {
            this.actions = actions;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProposalRequest build() {
            return new CreateProposalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
