/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMemberRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<CreateMemberRequest.Builder, CreateMemberRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMemberRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitationId").getter(getter(CreateMemberRequest::invitationId)).setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()).build();

    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(CreateMemberRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<MemberConfiguration> MEMBER_CONFIGURATION_FIELD = SdkField
            .<MemberConfiguration> builder(MarshallingType.SDK_POJO).memberName("MemberConfiguration")
            .getter(getter(CreateMemberRequest::memberConfiguration)).setter(setter(Builder::memberConfiguration))
            .constructor(MemberConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            INVITATION_ID_FIELD, NETWORK_ID_FIELD, MEMBER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String invitationId;

    private final String networkId;

    private final MemberConfiguration memberConfiguration;

    private CreateMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.invitationId = builder.invitationId;
        this.networkId = builder.networkId;
        this.memberConfiguration = builder.memberConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than one time. This identifier is required only if you make a service request
     * directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than one time. This identifier is required only if you make a
     *         service request directly using an HTTP client. It is generated automatically if you use an Amazon Web
     *         Services SDK or the CLI.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The unique identifier of the invitation that is sent to the member to join the network.
     * </p>
     * 
     * @return The unique identifier of the invitation that is sent to the member to join the network.
     */
    public final String invitationId() {
        return invitationId;
    }

    /**
     * <p>
     * The unique identifier of the network in which the member is created.
     * </p>
     * 
     * @return The unique identifier of the network in which the member is created.
     */
    public final String networkId() {
        return networkId;
    }

    /**
     * <p>
     * Member configuration parameters.
     * </p>
     * 
     * @return Member configuration parameters.
     */
    public final MemberConfiguration memberConfiguration() {
        return memberConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(memberConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemberRequest)) {
            return false;
        }
        CreateMemberRequest other = (CreateMemberRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(invitationId(), other.invitationId()) && Objects.equals(networkId(), other.networkId())
                && Objects.equals(memberConfiguration(), other.memberConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMemberRequest").add("ClientRequestToken", clientRequestToken())
                .add("InvitationId", invitationId()).add("NetworkId", networkId())
                .add("MemberConfiguration", memberConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "InvitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "MemberConfiguration":
            return Optional.ofNullable(clazz.cast(memberConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("InvitationId", INVITATION_ID_FIELD);
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("MemberConfiguration", MEMBER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMemberRequest, T> g) {
        return obj -> g.apply((CreateMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMemberRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than one time. This identifier is required only if you make a service
         * request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or
         * the CLI.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than one time. This identifier is required only if you make a
         *        service request directly using an HTTP client. It is generated automatically if you use an Amazon Web
         *        Services SDK or the CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The unique identifier of the invitation that is sent to the member to join the network.
         * </p>
         * 
         * @param invitationId
         *        The unique identifier of the invitation that is sent to the member to join the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        /**
         * <p>
         * The unique identifier of the network in which the member is created.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network in which the member is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * Member configuration parameters.
         * </p>
         * 
         * @param memberConfiguration
         *        Member configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberConfiguration(MemberConfiguration memberConfiguration);

        /**
         * <p>
         * Member configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberConfiguration.Builder} avoiding the
         * need to create one manually via {@link MemberConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemberConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #memberConfiguration(MemberConfiguration)}.
         * 
         * @param memberConfiguration
         *        a consumer that will call methods on {@link MemberConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberConfiguration(MemberConfiguration)
         */
        default Builder memberConfiguration(Consumer<MemberConfiguration.Builder> memberConfiguration) {
            return memberConfiguration(MemberConfiguration.builder().applyMutation(memberConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String invitationId;

        private String networkId;

        private MemberConfiguration memberConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemberRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            invitationId(model.invitationId);
            networkId(model.networkId);
            memberConfiguration(model.memberConfiguration);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getInvitationId() {
            return invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final String getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final MemberConfiguration.Builder getMemberConfiguration() {
            return memberConfiguration != null ? memberConfiguration.toBuilder() : null;
        }

        public final void setMemberConfiguration(MemberConfiguration.BuilderImpl memberConfiguration) {
            this.memberConfiguration = memberConfiguration != null ? memberConfiguration.build() : null;
        }

        @Override
        public final Builder memberConfiguration(MemberConfiguration memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMemberRequest build() {
            return new CreateMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
