/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.managedblockchain.model.NodeFrameworkAttributes;
import software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration;
import software.amazon.awssdk.services.managedblockchain.model.NodeStatus;
import software.amazon.awssdk.services.managedblockchain.model.OutputTagMapCopier;
import software.amazon.awssdk.services.managedblockchain.model.StateDBType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(Node.getter(Node::networkId)).setter(Node.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(Node.getter(Node::memberId)).setter(Node.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Node.getter(Node::id)).setter(Node.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Node.getter(Node::instanceType)).setter(Node.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Node.getter(Node::availabilityZone)).setter(Node.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<NodeFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameworkAttributes").getter(Node.getter(Node::frameworkAttributes)).setter(Node.setter(Builder::frameworkAttributes)).constructor(NodeFrameworkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build()}).build();
    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingConfiguration").getter(Node.getter(Node::logPublishingConfiguration)).setter(Node.setter(Builder::logPublishingConfiguration)).constructor(NodeLogPublishingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build()}).build();
    private static final SdkField<String> STATE_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateDB").getter(Node.getter(Node::stateDBAsString)).setter(Node.setter(Builder::stateDB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateDB").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Node.getter(Node::statusAsString)).setter(Node.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(Node.getter(Node::creationDate)).setter(Node.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Node.getter(Node::tags)).setter(Node.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Node.getter(Node::arn)).setter(Node.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(Node.getter(Node::kmsKeyArn)).setter(Node.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, MEMBER_ID_FIELD, ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, FRAMEWORK_ATTRIBUTES_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD, STATE_DB_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, TAGS_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Node.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkId;
    private final String memberId;
    private final String id;
    private final String instanceType;
    private final String availabilityZone;
    private final NodeFrameworkAttributes frameworkAttributes;
    private final NodeLogPublishingConfiguration logPublishingConfiguration;
    private final String stateDB;
    private final String status;
    private final Instant creationDate;
    private final Map<String, String> tags;
    private final String arn;
    private final String kmsKeyArn;

    private Node(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.id = builder.id;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.stateDB = builder.stateDB;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.tags = builder.tags;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final String id() {
        return this.id;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final NodeFrameworkAttributes frameworkAttributes() {
        return this.frameworkAttributes;
    }

    public final NodeLogPublishingConfiguration logPublishingConfiguration() {
        return this.logPublishingConfiguration;
    }

    public final StateDBType stateDB() {
        return StateDBType.fromValue(this.stateDB);
    }

    public final String stateDBAsString() {
        return this.stateDB;
    }

    public final NodeStatus status() {
        return NodeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDBAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.frameworkAttributes(), other.frameworkAttributes()) && Objects.equals(this.logPublishingConfiguration(), other.logPublishingConfiguration()) && Objects.equals(this.stateDBAsString(), other.stateDBAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("NetworkId", (Object)this.networkId()).add("MemberId", (Object)this.memberId()).add("Id", (Object)this.id()).add("InstanceType", (Object)this.instanceType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("FrameworkAttributes", (Object)this.frameworkAttributes()).add("LogPublishingConfiguration", (Object)this.logPublishingConfiguration()).add("StateDB", (Object)this.stateDBAsString()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("Tags", this.hasTags() ? this.tags() : null).add("Arn", (Object)this.arn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "FrameworkAttributes": {
                return Optional.ofNullable(clazz.cast(this.frameworkAttributes()));
            }
            case "LogPublishingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logPublishingConfiguration()));
            }
            case "StateDB": {
                return Optional.ofNullable(clazz.cast(this.stateDBAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkId", NETWORK_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("FrameworkAttributes", FRAMEWORK_ATTRIBUTES_FIELD);
        map.put("LogPublishingConfiguration", LOG_PUBLISHING_CONFIGURATION_FIELD);
        map.put("StateDB", STATE_DB_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkId;
        private String memberId;
        private String id;
        private String instanceType;
        private String availabilityZone;
        private NodeFrameworkAttributes frameworkAttributes;
        private NodeLogPublishingConfiguration logPublishingConfiguration;
        private String stateDB;
        private String status;
        private Instant creationDate;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String arn;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.networkId(model.networkId);
            this.memberId(model.memberId);
            this.id(model.id);
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.frameworkAttributes(model.frameworkAttributes);
            this.logPublishingConfiguration(model.logPublishingConfiguration);
            this.stateDB(model.stateDB);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.tags(model.tags);
            this.arn(model.arn);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final NodeFrameworkAttributes.Builder getFrameworkAttributes() {
            return this.frameworkAttributes != null ? this.frameworkAttributes.toBuilder() : null;
        }

        public final void setFrameworkAttributes(NodeFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        @Override
        public final Builder frameworkAttributes(NodeFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return this.logPublishingConfiguration != null ? this.logPublishingConfiguration.toBuilder() : null;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final String getStateDB() {
            return this.stateDB;
        }

        public final void setStateDB(String stateDB) {
            this.stateDB = stateDB;
        }

        @Override
        public final Builder stateDB(String stateDB) {
            this.stateDB = stateDB;
            return this;
        }

        @Override
        public final Builder stateDB(StateDBType stateDB) {
            this.stateDB(stateDB == null ? null : stateDB.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder networkId(String var1);

        public Builder memberId(String var1);

        public Builder id(String var1);

        public Builder instanceType(String var1);

        public Builder availabilityZone(String var1);

        public Builder frameworkAttributes(NodeFrameworkAttributes var1);

        default public Builder frameworkAttributes(Consumer<NodeFrameworkAttributes.Builder> frameworkAttributes) {
            return this.frameworkAttributes((NodeFrameworkAttributes)((NodeFrameworkAttributes.Builder)NodeFrameworkAttributes.builder().applyMutation(frameworkAttributes)).build());
        }

        public Builder logPublishingConfiguration(NodeLogPublishingConfiguration var1);

        default public Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return this.logPublishingConfiguration((NodeLogPublishingConfiguration)((NodeLogPublishingConfiguration.Builder)NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)).build());
        }

        public Builder stateDB(String var1);

        public Builder stateDB(StateDBType var1);

        public Builder status(String var1);

        public Builder status(NodeStatus var1);

        public Builder creationDate(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder arn(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

