/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes;
import software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFrameworkAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFrameworkAttributes> {
    private static final SdkField<NetworkFabricAttributes> FABRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fabric").getter(NetworkFrameworkAttributes.getter(NetworkFrameworkAttributes::fabric)).setter(NetworkFrameworkAttributes.setter(Builder::fabric)).constructor(NetworkFabricAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()}).build();
    private static final SdkField<NetworkEthereumAttributes> ETHEREUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ethereum").getter(NetworkFrameworkAttributes.getter(NetworkFrameworkAttributes::ethereum)).setter(NetworkFrameworkAttributes.setter(Builder::ethereum)).constructor(NetworkEthereumAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethereum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD, ETHEREUM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFrameworkAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NetworkFabricAttributes fabric;
    private final NetworkEthereumAttributes ethereum;

    private NetworkFrameworkAttributes(BuilderImpl builder) {
        this.fabric = builder.fabric;
        this.ethereum = builder.ethereum;
    }

    public final NetworkFabricAttributes fabric() {
        return this.fabric;
    }

    public final NetworkEthereumAttributes ethereum() {
        return this.ethereum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fabric());
        hashCode = 31 * hashCode + Objects.hashCode(this.ethereum());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFrameworkAttributes)) {
            return false;
        }
        NetworkFrameworkAttributes other = (NetworkFrameworkAttributes)obj;
        return Objects.equals(this.fabric(), other.fabric()) && Objects.equals(this.ethereum(), other.ethereum());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFrameworkAttributes").add("Fabric", (Object)this.fabric()).add("Ethereum", (Object)this.ethereum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fabric": {
                return Optional.ofNullable(clazz.cast(this.fabric()));
            }
            case "Ethereum": {
                return Optional.ofNullable(clazz.cast(this.ethereum()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fabric", FABRIC_FIELD);
        map.put("Ethereum", ETHEREUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFrameworkAttributes, T> g) {
        return obj -> g.apply((NetworkFrameworkAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkFabricAttributes fabric;
        private NetworkEthereumAttributes ethereum;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFrameworkAttributes model) {
            this.fabric(model.fabric);
            this.ethereum(model.ethereum);
        }

        public final NetworkFabricAttributes.Builder getFabric() {
            return this.fabric != null ? this.fabric.toBuilder() : null;
        }

        public final void setFabric(NetworkFabricAttributes.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        public final Builder fabric(NetworkFabricAttributes fabric) {
            this.fabric = fabric;
            return this;
        }

        public final NetworkEthereumAttributes.Builder getEthereum() {
            return this.ethereum != null ? this.ethereum.toBuilder() : null;
        }

        public final void setEthereum(NetworkEthereumAttributes.BuilderImpl ethereum) {
            this.ethereum = ethereum != null ? ethereum.build() : null;
        }

        @Override
        public final Builder ethereum(NetworkEthereumAttributes ethereum) {
            this.ethereum = ethereum;
            return this;
        }

        public NetworkFrameworkAttributes build() {
            return new NetworkFrameworkAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFrameworkAttributes> {
        public Builder fabric(NetworkFabricAttributes var1);

        default public Builder fabric(Consumer<NetworkFabricAttributes.Builder> fabric) {
            return this.fabric((NetworkFabricAttributes)((NetworkFabricAttributes.Builder)NetworkFabricAttributes.builder().applyMutation(fabric)).build());
        }

        public Builder ethereum(NetworkEthereumAttributes var1);

        default public Builder ethereum(Consumer<NetworkEthereumAttributes.Builder> ethereum) {
            return this.ethereum((NetworkEthereumAttributes)((NetworkEthereumAttributes.Builder)NetworkEthereumAttributes.builder().applyMutation(ethereum)).build());
        }
    }
}

