/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.AccessorSummary;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse;

public class ListAccessorsPublisher
implements SdkPublisher<ListAccessorsResponse> {
    private final ManagedBlockchainAsyncClient client;
    private final ListAccessorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessorsPublisher(ManagedBlockchainAsyncClient client, ListAccessorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessorsPublisher(ManagedBlockchainAsyncClient client, ListAccessorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessorSummary> accessors() {
        Function<ListAccessorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessors() != null) {
                return response.accessors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessorsResponseFetcher
    implements AsyncPageFetcher<ListAccessorsResponse> {
        private ListAccessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessorsResponse> nextPage(ListAccessorsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessorsPublisher.this.client.listAccessors(ListAccessorsPublisher.this.firstRequest);
            }
            return ListAccessorsPublisher.this.client.listAccessors((ListAccessorsRequest)((Object)ListAccessorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

