/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.model.AccessorSummary;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse;

public class ListAccessorsIterable
implements SdkIterable<ListAccessorsResponse> {
    private final ManagedBlockchainClient client;
    private final ListAccessorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessorsIterable(ManagedBlockchainClient client, ListAccessorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessorsResponseFetcher();
    }

    public Iterator<ListAccessorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessorSummary> accessors() {
        Function<ListAccessorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessors() != null) {
                return response.accessors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessorsResponseFetcher
    implements SyncPageFetcher<ListAccessorsResponse> {
        private ListAccessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessorsResponse nextPage(ListAccessorsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessorsIterable.this.client.listAccessors(ListAccessorsIterable.this.firstRequest);
            }
            return ListAccessorsIterable.this.client.listAccessors((ListAccessorsRequest)((Object)ListAccessorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

