/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse;

public class ListNetworksPublisher
implements SdkPublisher<ListNetworksResponse> {
    private final ManagedBlockchainAsyncClient client;
    private final ListNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworksPublisher(ManagedBlockchainAsyncClient client, ListNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworksPublisher(ManagedBlockchainAsyncClient client, ListNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNetworksResponseFetcher
    implements AsyncPageFetcher<ListNetworksResponse> {
        private ListNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworksResponse> nextPage(ListNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListNetworksPublisher.this.client.listNetworks(ListNetworksPublisher.this.firstRequest);
            }
            return ListNetworksPublisher.this.client.listNetworks((ListNetworksRequest)((Object)ListNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

