/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VoteValue {
    YES("YES"),
    NO("NO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VoteValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VoteValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VoteValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VoteValue> knownValues() {
        return Stream.of(VoteValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

