/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.InvitationStatus;
import software.amazon.awssdk.services.managedblockchain.model.NetworkSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Invitation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Invitation> {
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Invitation.getter(Invitation::invitationId)).setter(Invitation.setter(Builder::invitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Invitation.getter(Invitation::creationDate)).setter(Invitation.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Invitation.getter(Invitation::expirationDate)).setter(Invitation.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Invitation.getter(Invitation::statusAsString)).setter(Invitation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<NetworkSummary> NETWORK_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Invitation.getter(Invitation::networkSummary)).setter(Invitation.setter(Builder::networkSummary)).constructor(NetworkSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATION_ID_FIELD, CREATION_DATE_FIELD, EXPIRATION_DATE_FIELD, STATUS_FIELD, NETWORK_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String invitationId;
    private final Instant creationDate;
    private final Instant expirationDate;
    private final String status;
    private final NetworkSummary networkSummary;

    private Invitation(BuilderImpl builder) {
        this.invitationId = builder.invitationId;
        this.creationDate = builder.creationDate;
        this.expirationDate = builder.expirationDate;
        this.status = builder.status;
        this.networkSummary = builder.networkSummary;
    }

    public String invitationId() {
        return this.invitationId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public InvitationStatus status() {
        return InvitationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public NetworkSummary networkSummary() {
        return this.networkSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invitation)) {
            return false;
        }
        Invitation other = (Invitation)obj;
        return Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.networkSummary(), other.networkSummary());
    }

    public String toString() {
        return ToString.builder((String)"Invitation").add("InvitationId", (Object)this.invitationId()).add("CreationDate", (Object)this.creationDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Status", (Object)this.statusAsString()).add("NetworkSummary", (Object)this.networkSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NetworkSummary": {
                return Optional.ofNullable(clazz.cast(this.networkSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invitation, T> g) {
        return obj -> g.apply((Invitation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invitationId;
        private Instant creationDate;
        private Instant expirationDate;
        private String status;
        private NetworkSummary networkSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Invitation model) {
            this.invitationId(model.invitationId);
            this.creationDate(model.creationDate);
            this.expirationDate(model.expirationDate);
            this.status(model.status);
            this.networkSummary(model.networkSummary);
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final NetworkSummary.Builder getNetworkSummary() {
            return this.networkSummary != null ? this.networkSummary.toBuilder() : null;
        }

        @Override
        public final Builder networkSummary(NetworkSummary networkSummary) {
            this.networkSummary = networkSummary;
            return this;
        }

        public final void setNetworkSummary(NetworkSummary.BuilderImpl networkSummary) {
            this.networkSummary = networkSummary != null ? networkSummary.build() : null;
        }

        public Invitation build() {
            return new Invitation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Invitation> {
        public Builder invitationId(String var1);

        public Builder creationDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder status(String var1);

        public Builder status(InvitationStatus var1);

        public Builder networkSummary(NetworkSummary var1);

        default public Builder networkSummary(Consumer<NetworkSummary.Builder> networkSummary) {
            return this.networkSummary((NetworkSummary)((NetworkSummary.Builder)NetworkSummary.builder().applyMutation(networkSummary)).build());
        }
    }
}

