/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Framework;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.NetworkStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworksRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, ListNetworksRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNetworksRequest.getter(ListNetworksRequest::name)).setter(ListNetworksRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNetworksRequest.getter(ListNetworksRequest::frameworkAsString)).setter(ListNetworksRequest.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("framework").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNetworksRequest.getter(ListNetworksRequest::statusAsString)).setter(ListNetworksRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListNetworksRequest.getter(ListNetworksRequest::maxResults)).setter(ListNetworksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNetworksRequest.getter(ListNetworksRequest::nextToken)).setter(ListNetworksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FRAMEWORK_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String name;
    private final String framework;
    private final String status;
    private final Integer maxResults;
    private final String nextToken;

    private ListNetworksRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.framework = builder.framework;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String name() {
        return this.name;
    }

    public Framework framework() {
        return Framework.fromValue(this.framework);
    }

    public String frameworkAsString() {
        return this.framework;
    }

    public NetworkStatus status() {
        return NetworkStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksRequest)) {
            return false;
        }
        ListNetworksRequest other = (ListNetworksRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.frameworkAsString(), other.frameworkAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNetworksRequest").add("Name", (Object)this.name()).add("Framework", (Object)this.frameworkAsString()).add("Status", (Object)this.statusAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.frameworkAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworksRequest, T> g) {
        return obj -> g.apply((ListNetworksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String name;
        private String framework;
        private String status;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworksRequest model) {
            super(model);
            this.name(model.name);
            this.framework(model.framework);
            this.status(model.status);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFrameworkAsString() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNetworksRequest build() {
            return new ListNetworksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworksRequest> {
        public Builder name(String var1);

        public Builder framework(String var1);

        public Builder framework(Framework var1);

        public Builder status(String var1);

        public Builder status(NetworkStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

