/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.IngressAddressListArnListCopier;
import software.amazon.awssdk.services.mailmanager.model.IngressAddressListEmailAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressIsInAddressList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressIsInAddressList> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(IngressIsInAddressList.getter(IngressIsInAddressList::attributeAsString)).setter(IngressIsInAddressList.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<List<String>> ADDRESS_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressLists").getter(IngressIsInAddressList.getter(IngressIsInAddressList::addressLists)).setter(IngressIsInAddressList.setter(Builder::addressLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ADDRESS_LISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressIsInAddressList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final List<String> addressLists;

    private IngressIsInAddressList(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.addressLists = builder.addressLists;
    }

    public final IngressAddressListEmailAttribute attribute() {
        return IngressAddressListEmailAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final boolean hasAddressLists() {
        return this.addressLists != null && !(this.addressLists instanceof SdkAutoConstructList);
    }

    public final List<String> addressLists() {
        return this.addressLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressLists() ? this.addressLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressIsInAddressList)) {
            return false;
        }
        IngressIsInAddressList other = (IngressIsInAddressList)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && this.hasAddressLists() == other.hasAddressLists() && Objects.equals(this.addressLists(), other.addressLists());
    }

    public final String toString() {
        return ToString.builder((String)"IngressIsInAddressList").add("Attribute", (Object)this.attributeAsString()).add("AddressLists", this.hasAddressLists() ? this.addressLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "AddressLists": {
                return Optional.ofNullable(clazz.cast(this.addressLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("AddressLists", ADDRESS_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressIsInAddressList, T> g) {
        return obj -> g.apply((IngressIsInAddressList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private List<String> addressLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngressIsInAddressList model) {
            this.attribute(model.attribute);
            this.addressLists(model.addressLists);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(IngressAddressListEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final Collection<String> getAddressLists() {
            if (this.addressLists instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addressLists;
        }

        public final void setAddressLists(Collection<String> addressLists) {
            this.addressLists = IngressAddressListArnListCopier.copy(addressLists);
        }

        @Override
        public final Builder addressLists(Collection<String> addressLists) {
            this.addressLists = IngressAddressListArnListCopier.copy(addressLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(String ... addressLists) {
            this.addressLists(Arrays.asList(addressLists));
            return this;
        }

        public IngressIsInAddressList build() {
            return new IngressIsInAddressList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressIsInAddressList> {
        public Builder attribute(String var1);

        public Builder attribute(IngressAddressListEmailAttribute var1);

        public Builder addressLists(Collection<String> var1);

        public Builder addressLists(String ... var1);
    }
}

