/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.AcceptAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficPolicy> {
    private static final SdkField<String> TRAFFIC_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyName").getter(TrafficPolicy.getter(TrafficPolicy::trafficPolicyName)).setter(TrafficPolicy.setter(Builder::trafficPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyName").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(TrafficPolicy.getter(TrafficPolicy::trafficPolicyId)).setter(TrafficPolicy.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultAction").getter(TrafficPolicy.getter(TrafficPolicy::defaultActionAsString)).setter(TrafficPolicy.setter(Builder::defaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_NAME_FIELD, TRAFFIC_POLICY_ID_FIELD, DEFAULT_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trafficPolicyName;
    private final String trafficPolicyId;
    private final String defaultAction;

    private TrafficPolicy(BuilderImpl builder) {
        this.trafficPolicyName = builder.trafficPolicyName;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.defaultAction = builder.defaultAction;
    }

    public final String trafficPolicyName() {
        return this.trafficPolicyName;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public final AcceptAction defaultAction() {
        return AcceptAction.fromValue(this.defaultAction);
    }

    public final String defaultActionAsString() {
        return this.defaultAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicy)) {
            return false;
        }
        TrafficPolicy other = (TrafficPolicy)obj;
        return Objects.equals(this.trafficPolicyName(), other.trafficPolicyName()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.defaultActionAsString(), other.defaultActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficPolicy").add("TrafficPolicyName", (Object)this.trafficPolicyName()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("DefaultAction", (Object)this.defaultActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicyName": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyName()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TrafficPolicyName", TRAFFIC_POLICY_NAME_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficPolicy, T> g) {
        return obj -> g.apply((TrafficPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficPolicyName;
        private String trafficPolicyId;
        private String defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicy model) {
            this.trafficPolicyName(model.trafficPolicyName);
            this.trafficPolicyId(model.trafficPolicyId);
            this.defaultAction(model.defaultAction);
        }

        public final String getTrafficPolicyName() {
            return this.trafficPolicyName;
        }

        public final void setTrafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
        }

        @Override
        public final Builder trafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(AcceptAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public TrafficPolicy build() {
            return new TrafficPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficPolicy> {
        public Builder trafficPolicyName(String var1);

        public Builder trafficPolicyId(String var1);

        public Builder defaultAction(String var1);

        public Builder defaultAction(AcceptAction var1);
    }
}

