/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.IngressAnalysis;
import software.amazon.awssdk.services.mailmanager.model.IngressStringEmailAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressStringToEvaluate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressStringToEvaluate> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(IngressStringToEvaluate.getter(IngressStringToEvaluate::attributeAsString)).setter(IngressStringToEvaluate.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<IngressAnalysis> ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Analysis").getter(IngressStringToEvaluate.getter(IngressStringToEvaluate::analysis)).setter(IngressStringToEvaluate.setter(Builder::analysis)).constructor(IngressAnalysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ANALYSIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressStringToEvaluate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final IngressAnalysis analysis;
    private final Type type;

    private IngressStringToEvaluate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.analysis = builder.analysis;
        this.type = builder.type;
    }

    public final IngressStringEmailAttribute attribute() {
        return IngressStringEmailAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final IngressAnalysis analysis() {
        return this.analysis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressStringToEvaluate)) {
            return false;
        }
        IngressStringToEvaluate other = (IngressStringToEvaluate)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.analysis(), other.analysis());
    }

    public final String toString() {
        return ToString.builder((String)"IngressStringToEvaluate").add("Attribute", (Object)this.attributeAsString()).add("Analysis", (Object)this.analysis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "Analysis": {
                return Optional.ofNullable(clazz.cast(this.analysis()));
            }
        }
        return Optional.empty();
    }

    public static IngressStringToEvaluate fromAttribute(String attribute) {
        return (IngressStringToEvaluate)IngressStringToEvaluate.builder().attribute(attribute).build();
    }

    public static IngressStringToEvaluate fromAttribute(IngressStringEmailAttribute attribute) {
        return (IngressStringToEvaluate)IngressStringToEvaluate.builder().attribute(attribute).build();
    }

    public static IngressStringToEvaluate fromAnalysis(IngressAnalysis analysis) {
        return (IngressStringToEvaluate)IngressStringToEvaluate.builder().analysis(analysis).build();
    }

    public static IngressStringToEvaluate fromAnalysis(Consumer<IngressAnalysis.Builder> analysis) {
        IngressAnalysis.Builder builder = IngressAnalysis.builder();
        analysis.accept(builder);
        return IngressStringToEvaluate.fromAnalysis((IngressAnalysis)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressStringToEvaluate, T> g) {
        return obj -> g.apply((IngressStringToEvaluate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ATTRIBUTE,
        ANALYSIS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private IngressAnalysis analysis;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IngressStringToEvaluate model) {
            this.attribute(model.attribute);
            this.analysis(model.analysis);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(IngressStringEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final IngressAnalysis.Builder getAnalysis() {
            return this.analysis != null ? this.analysis.toBuilder() : null;
        }

        public final void setAnalysis(IngressAnalysis.BuilderImpl analysis) {
            IngressAnalysis oldValue = this.analysis;
            this.analysis = analysis != null ? analysis.build() : null;
            this.handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
        }

        @Override
        public final Builder analysis(IngressAnalysis analysis) {
            IngressAnalysis oldValue = this.analysis;
            this.analysis = analysis;
            this.handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
            return this;
        }

        public IngressStringToEvaluate build() {
            return new IngressStringToEvaluate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressStringToEvaluate> {
        public Builder attribute(String var1);

        public Builder attribute(IngressStringEmailAttribute var1);

        public Builder analysis(IngressAnalysis var1);

        default public Builder analysis(Consumer<IngressAnalysis.Builder> analysis) {
            return this.analysis((IngressAnalysis)((IngressAnalysis.Builder)IngressAnalysis.builder().applyMutation(analysis)).build());
        }
    }
}

