/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressAnalysis> {
    private static final SdkField<String> ANALYZER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Analyzer").getter(IngressAnalysis.getter(IngressAnalysis::analyzer)).setter(IngressAnalysis.setter(Builder::analyzer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyzer").build()}).build();
    private static final SdkField<String> RESULT_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultField").getter(IngressAnalysis.getter(IngressAnalysis::resultField)).setter(IngressAnalysis.setter(Builder::resultField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_FIELD, RESULT_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressAnalysis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String analyzer;
    private final String resultField;

    private IngressAnalysis(BuilderImpl builder) {
        this.analyzer = builder.analyzer;
        this.resultField = builder.resultField;
    }

    public final String analyzer() {
        return this.analyzer;
    }

    public final String resultField() {
        return this.resultField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzer());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressAnalysis)) {
            return false;
        }
        IngressAnalysis other = (IngressAnalysis)obj;
        return Objects.equals(this.analyzer(), other.analyzer()) && Objects.equals(this.resultField(), other.resultField());
    }

    public final String toString() {
        return ToString.builder((String)"IngressAnalysis").add("Analyzer", (Object)this.analyzer()).add("ResultField", (Object)this.resultField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Analyzer": {
                return Optional.ofNullable(clazz.cast(this.analyzer()));
            }
            case "ResultField": {
                return Optional.ofNullable(clazz.cast(this.resultField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Analyzer", ANALYZER_FIELD);
        map.put("ResultField", RESULT_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressAnalysis, T> g) {
        return obj -> g.apply((IngressAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analyzer;
        private String resultField;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressAnalysis model) {
            this.analyzer(model.analyzer);
            this.resultField(model.resultField);
        }

        public final String getAnalyzer() {
            return this.analyzer;
        }

        public final void setAnalyzer(String analyzer) {
            this.analyzer = analyzer;
        }

        @Override
        public final Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public final String getResultField() {
            return this.resultField;
        }

        public final void setResultField(String resultField) {
            this.resultField = resultField;
        }

        @Override
        public final Builder resultField(String resultField) {
            this.resultField = resultField;
            return this;
        }

        public IngressAnalysis build() {
            return new IngressAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressAnalysis> {
        public Builder analyzer(String var1);

        public Builder resultField(String var1);
    }
}

