/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.IngressPointAuthConfiguration;
import software.amazon.awssdk.services.mailmanager.model.IngressPointStatus;
import software.amazon.awssdk.services.mailmanager.model.IngressPointType;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.NetworkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIngressPointResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetIngressPointResponse> {
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointId").getter(GetIngressPointResponse.getter(GetIngressPointResponse::ingressPointId)).setter(GetIngressPointResponse.setter(Builder::ingressPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()}).build();
    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointName").getter(GetIngressPointResponse.getter(GetIngressPointResponse::ingressPointName)).setter(GetIngressPointResponse.setter(Builder::ingressPointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()}).build();
    private static final SdkField<String> INGRESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointArn").getter(GetIngressPointResponse.getter(GetIngressPointResponse::ingressPointArn)).setter(GetIngressPointResponse.setter(Builder::ingressPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetIngressPointResponse.getter(GetIngressPointResponse::statusAsString)).setter(GetIngressPointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetIngressPointResponse.getter(GetIngressPointResponse::typeAsString)).setter(GetIngressPointResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> A_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARecord").getter(GetIngressPointResponse.getter(GetIngressPointResponse::aRecord)).setter(GetIngressPointResponse.setter(Builder::aRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARecord").build()}).build();
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetId").getter(GetIngressPointResponse.getter(GetIngressPointResponse::ruleSetId)).setter(GetIngressPointResponse.setter(Builder::ruleSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(GetIngressPointResponse.getter(GetIngressPointResponse::trafficPolicyId)).setter(GetIngressPointResponse.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final SdkField<IngressPointAuthConfiguration> INGRESS_POINT_AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressPointAuthConfiguration").getter(GetIngressPointResponse.getter(GetIngressPointResponse::ingressPointAuthConfiguration)).setter(GetIngressPointResponse.setter(Builder::ingressPointAuthConfiguration)).constructor(IngressPointAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointAuthConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(GetIngressPointResponse.getter(GetIngressPointResponse::networkConfiguration)).setter(GetIngressPointResponse.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetIngressPointResponse.getter(GetIngressPointResponse::createdTimestamp)).setter(GetIngressPointResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetIngressPointResponse.getter(GetIngressPointResponse::lastUpdatedTimestamp)).setter(GetIngressPointResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_ID_FIELD, INGRESS_POINT_NAME_FIELD, INGRESS_POINT_ARN_FIELD, STATUS_FIELD, TYPE_FIELD, A_RECORD_FIELD, RULE_SET_ID_FIELD, TRAFFIC_POLICY_ID_FIELD, INGRESS_POINT_AUTH_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIngressPointResponse.memberNameToFieldInitializer();
    private final String ingressPointId;
    private final String ingressPointName;
    private final String ingressPointArn;
    private final String status;
    private final String type;
    private final String aRecord;
    private final String ruleSetId;
    private final String trafficPolicyId;
    private final IngressPointAuthConfiguration ingressPointAuthConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;

    private GetIngressPointResponse(BuilderImpl builder) {
        super(builder);
        this.ingressPointId = builder.ingressPointId;
        this.ingressPointName = builder.ingressPointName;
        this.ingressPointArn = builder.ingressPointArn;
        this.status = builder.status;
        this.type = builder.type;
        this.aRecord = builder.aRecord;
        this.ruleSetId = builder.ruleSetId;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.ingressPointAuthConfiguration = builder.ingressPointAuthConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String ingressPointId() {
        return this.ingressPointId;
    }

    public final String ingressPointName() {
        return this.ingressPointName;
    }

    public final String ingressPointArn() {
        return this.ingressPointArn;
    }

    public final IngressPointStatus status() {
        return IngressPointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final IngressPointType type() {
        return IngressPointType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String aRecord() {
        return this.aRecord;
    }

    public final String ruleSetId() {
        return this.ruleSetId;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public final IngressPointAuthConfiguration ingressPointAuthConfiguration() {
        return this.ingressPointAuthConfiguration;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIngressPointResponse)) {
            return false;
        }
        GetIngressPointResponse other = (GetIngressPointResponse)((Object)obj);
        return Objects.equals(this.ingressPointId(), other.ingressPointId()) && Objects.equals(this.ingressPointName(), other.ingressPointName()) && Objects.equals(this.ingressPointArn(), other.ingressPointArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.aRecord(), other.aRecord()) && Objects.equals(this.ruleSetId(), other.ruleSetId()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.ingressPointAuthConfiguration(), other.ingressPointAuthConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetIngressPointResponse").add("IngressPointId", (Object)this.ingressPointId()).add("IngressPointName", (Object)this.ingressPointName()).add("IngressPointArn", (Object)this.ingressPointArn()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("ARecord", (Object)this.aRecord()).add("RuleSetId", (Object)this.ruleSetId()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("IngressPointAuthConfiguration", (Object)this.ingressPointAuthConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngressPointId": {
                return Optional.ofNullable(clazz.cast(this.ingressPointId()));
            }
            case "IngressPointName": {
                return Optional.ofNullable(clazz.cast(this.ingressPointName()));
            }
            case "IngressPointArn": {
                return Optional.ofNullable(clazz.cast(this.ingressPointArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ARecord": {
                return Optional.ofNullable(clazz.cast(this.aRecord()));
            }
            case "RuleSetId": {
                return Optional.ofNullable(clazz.cast(this.ruleSetId()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "IngressPointAuthConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressPointAuthConfiguration()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("IngressPointArn", INGRESS_POINT_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ARecord", A_RECORD_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("IngressPointAuthConfiguration", INGRESS_POINT_AUTH_CONFIGURATION_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIngressPointResponse, T> g) {
        return obj -> g.apply((GetIngressPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String ingressPointId;
        private String ingressPointName;
        private String ingressPointArn;
        private String status;
        private String type;
        private String aRecord;
        private String ruleSetId;
        private String trafficPolicyId;
        private IngressPointAuthConfiguration ingressPointAuthConfiguration;
        private NetworkConfiguration networkConfiguration;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIngressPointResponse model) {
            super(model);
            this.ingressPointId(model.ingressPointId);
            this.ingressPointName(model.ingressPointName);
            this.ingressPointArn(model.ingressPointArn);
            this.status(model.status);
            this.type(model.type);
            this.aRecord(model.aRecord);
            this.ruleSetId(model.ruleSetId);
            this.trafficPolicyId(model.trafficPolicyId);
            this.ingressPointAuthConfiguration(model.ingressPointAuthConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getIngressPointId() {
            return this.ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getIngressPointName() {
            return this.ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getIngressPointArn() {
            return this.ingressPointArn;
        }

        public final void setIngressPointArn(String ingressPointArn) {
            this.ingressPointArn = ingressPointArn;
        }

        @Override
        public final Builder ingressPointArn(String ingressPointArn) {
            this.ingressPointArn = ingressPointArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngressPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getARecord() {
            return this.aRecord;
        }

        public final void setARecord(String aRecord) {
            this.aRecord = aRecord;
        }

        @Override
        public final Builder aRecord(String aRecord) {
            this.aRecord = aRecord;
            return this;
        }

        public final String getRuleSetId() {
            return this.ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final IngressPointAuthConfiguration.Builder getIngressPointAuthConfiguration() {
            return this.ingressPointAuthConfiguration != null ? this.ingressPointAuthConfiguration.toBuilder() : null;
        }

        public final void setIngressPointAuthConfiguration(IngressPointAuthConfiguration.BuilderImpl ingressPointAuthConfiguration) {
            this.ingressPointAuthConfiguration = ingressPointAuthConfiguration != null ? ingressPointAuthConfiguration.build() : null;
        }

        @Override
        public final Builder ingressPointAuthConfiguration(IngressPointAuthConfiguration ingressPointAuthConfiguration) {
            this.ingressPointAuthConfiguration = ingressPointAuthConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public GetIngressPointResponse build() {
            return new GetIngressPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIngressPointResponse> {
        public Builder ingressPointId(String var1);

        public Builder ingressPointName(String var1);

        public Builder ingressPointArn(String var1);

        public Builder status(String var1);

        public Builder status(IngressPointStatus var1);

        public Builder type(String var1);

        public Builder type(IngressPointType var1);

        public Builder aRecord(String var1);

        public Builder ruleSetId(String var1);

        public Builder trafficPolicyId(String var1);

        public Builder ingressPointAuthConfiguration(IngressPointAuthConfiguration var1);

        default public Builder ingressPointAuthConfiguration(Consumer<IngressPointAuthConfiguration.Builder> ingressPointAuthConfiguration) {
            return this.ingressPointAuthConfiguration((IngressPointAuthConfiguration)((IngressPointAuthConfiguration.Builder)IngressPointAuthConfiguration.builder().applyMutation(ingressPointAuthConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

