/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveFilters;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.SearchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveSearchResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetArchiveSearchResponse> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::archiveId)).setter(GetArchiveSearchResponse.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<ArchiveFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::filters)).setter(GetArchiveSearchResponse.setter(Builder::filters)).constructor(ArchiveFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Instant> FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FromTimestamp").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::fromTimestamp)).setter(GetArchiveSearchResponse.setter(Builder::fromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTimestamp").build()}).build();
    private static final SdkField<Instant> TO_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ToTimestamp").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::toTimestamp)).setter(GetArchiveSearchResponse.setter(Builder::toTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTimestamp").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::maxResults)).setter(GetArchiveSearchResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<SearchStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetArchiveSearchResponse.getter(GetArchiveSearchResponse::status)).setter(GetArchiveSearchResponse.setter(Builder::status)).constructor(SearchStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD, FILTERS_FIELD, FROM_TIMESTAMP_FIELD, TO_TIMESTAMP_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetArchiveSearchResponse.memberNameToFieldInitializer();
    private final String archiveId;
    private final ArchiveFilters filters;
    private final Instant fromTimestamp;
    private final Instant toTimestamp;
    private final Integer maxResults;
    private final SearchStatus status;

    private GetArchiveSearchResponse(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.filters = builder.filters;
        this.fromTimestamp = builder.fromTimestamp;
        this.toTimestamp = builder.toTimestamp;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final ArchiveFilters filters() {
        return this.filters;
    }

    public final Instant fromTimestamp() {
        return this.fromTimestamp;
    }

    public final Instant toTimestamp() {
        return this.toTimestamp;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SearchStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.toTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveSearchResponse)) {
            return false;
        }
        GetArchiveSearchResponse other = (GetArchiveSearchResponse)((Object)obj);
        return Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.fromTimestamp(), other.fromTimestamp()) && Objects.equals(this.toTimestamp(), other.toTimestamp()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveSearchResponse").add("ArchiveId", (Object)this.archiveId()).add("Filters", (Object)this.filters()).add("FromTimestamp", (Object)this.fromTimestamp()).add("ToTimestamp", (Object)this.toTimestamp()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "FromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.fromTimestamp()));
            }
            case "ToTimestamp": {
                return Optional.ofNullable(clazz.cast(this.toTimestamp()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("FromTimestamp", FROM_TIMESTAMP_FIELD);
        map.put("ToTimestamp", TO_TIMESTAMP_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveSearchResponse, T> g) {
        return obj -> g.apply((GetArchiveSearchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String archiveId;
        private ArchiveFilters filters;
        private Instant fromTimestamp;
        private Instant toTimestamp;
        private Integer maxResults;
        private SearchStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveSearchResponse model) {
            super(model);
            this.archiveId(model.archiveId);
            this.filters(model.filters);
            this.fromTimestamp(model.fromTimestamp);
            this.toTimestamp(model.toTimestamp);
            this.maxResults(model.maxResults);
            this.status(model.status);
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final ArchiveFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ArchiveFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ArchiveFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getFromTimestamp() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
        }

        @Override
        public final Builder fromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public final Instant getToTimestamp() {
            return this.toTimestamp;
        }

        public final void setToTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
        }

        @Override
        public final Builder toTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SearchStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public GetArchiveSearchResponse build() {
            return new GetArchiveSearchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveSearchResponse> {
        public Builder archiveId(String var1);

        public Builder filters(ArchiveFilters var1);

        default public Builder filters(Consumer<ArchiveFilters.Builder> filters) {
            return this.filters((ArchiveFilters)((ArchiveFilters.Builder)ArchiveFilters.builder().applyMutation(filters)).build());
        }

        public Builder fromTimestamp(Instant var1);

        public Builder toTimestamp(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder status(SearchStatus var1);

        default public Builder status(Consumer<SearchStatus.Builder> status) {
            return this.status((SearchStatus)((SearchStatus.Builder)SearchStatus.builder().applyMutation(status)).build());
        }
    }
}

