/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ExportState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportStatus> {
    private static final SdkField<Instant> SUBMISSION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmissionTimestamp").getter(ExportStatus.getter(ExportStatus::submissionTimestamp)).setter(ExportStatus.setter(Builder::submissionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTimestamp").getter(ExportStatus.getter(ExportStatus::completionTimestamp)).setter(ExportStatus.setter(Builder::completionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ExportStatus.getter(ExportStatus::stateAsString)).setter(ExportStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ExportStatus.getter(ExportStatus::errorMessage)).setter(ExportStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMISSION_TIMESTAMP_FIELD, COMPLETION_TIMESTAMP_FIELD, STATE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant submissionTimestamp;
    private final Instant completionTimestamp;
    private final String state;
    private final String errorMessage;

    private ExportStatus(BuilderImpl builder) {
        this.submissionTimestamp = builder.submissionTimestamp;
        this.completionTimestamp = builder.completionTimestamp;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
    }

    public final Instant submissionTimestamp() {
        return this.submissionTimestamp;
    }

    public final Instant completionTimestamp() {
        return this.completionTimestamp;
    }

    public final ExportState state() {
        return ExportState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatus)) {
            return false;
        }
        ExportStatus other = (ExportStatus)obj;
        return Objects.equals(this.submissionTimestamp(), other.submissionTimestamp()) && Objects.equals(this.completionTimestamp(), other.completionTimestamp()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ExportStatus").add("SubmissionTimestamp", (Object)this.submissionTimestamp()).add("CompletionTimestamp", (Object)this.completionTimestamp()).add("State", (Object)this.stateAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubmissionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.submissionTimestamp()));
            }
            case "CompletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completionTimestamp()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubmissionTimestamp", SUBMISSION_TIMESTAMP_FIELD);
        map.put("CompletionTimestamp", COMPLETION_TIMESTAMP_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportStatus, T> g) {
        return obj -> g.apply((ExportStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant submissionTimestamp;
        private Instant completionTimestamp;
        private String state;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatus model) {
            this.submissionTimestamp(model.submissionTimestamp);
            this.completionTimestamp(model.completionTimestamp);
            this.state(model.state);
            this.errorMessage(model.errorMessage);
        }

        public final Instant getSubmissionTimestamp() {
            return this.submissionTimestamp;
        }

        public final void setSubmissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
        }

        @Override
        public final Builder submissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
            return this;
        }

        public final Instant getCompletionTimestamp() {
            return this.completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ExportStatus build() {
            return new ExportStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportStatus> {
        public Builder submissionTimestamp(Instant var1);

        public Builder completionTimestamp(Instant var1);

        public Builder state(String var1);

        public Builder state(ExportState var1);

        public Builder errorMessage(String var1);
    }
}

