/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition;
import software.amazon.awssdk.services.mailmanager.model.ArchiveFilterConditionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveFilters> {
    private static final SdkField<List<ArchiveFilterCondition>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Include").getter(ArchiveFilters.getter(ArchiveFilters::include)).setter(ArchiveFilters.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArchiveFilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ArchiveFilterCondition>> UNLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unless").getter(ArchiveFilters.getter(ArchiveFilters::unless)).setter(ArchiveFilters.setter(Builder::unless)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unless").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArchiveFilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, UNLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArchiveFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ArchiveFilterCondition> include;
    private final List<ArchiveFilterCondition> unless;

    private ArchiveFilters(BuilderImpl builder) {
        this.include = builder.include;
        this.unless = builder.unless;
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public final List<ArchiveFilterCondition> include() {
        return this.include;
    }

    public final boolean hasUnless() {
        return this.unless != null && !(this.unless instanceof SdkAutoConstructList);
    }

    public final List<ArchiveFilterCondition> unless() {
        return this.unless;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.include() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnless() ? this.unless() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveFilters)) {
            return false;
        }
        ArchiveFilters other = (ArchiveFilters)obj;
        return this.hasInclude() == other.hasInclude() && Objects.equals(this.include(), other.include()) && this.hasUnless() == other.hasUnless() && Objects.equals(this.unless(), other.unless());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveFilters").add("Include", this.hasInclude() ? this.include() : null).add("Unless", this.hasUnless() ? this.unless() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.include()));
            }
            case "Unless": {
                return Optional.ofNullable(clazz.cast(this.unless()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ArchiveFilterCondition>>> map = new HashMap<String, SdkField<List<ArchiveFilterCondition>>>();
        map.put("Include", INCLUDE_FIELD);
        map.put("Unless", UNLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveFilters, T> g) {
        return obj -> g.apply((ArchiveFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ArchiveFilterCondition> include = DefaultSdkAutoConstructList.getInstance();
        private List<ArchiveFilterCondition> unless = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveFilters model) {
            this.include(model.include);
            this.unless(model.unless);
        }

        public final List<ArchiveFilterCondition.Builder> getInclude() {
            List<ArchiveFilterCondition.Builder> result = ArchiveFilterConditionsCopier.copyToBuilder(this.include);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclude(Collection<ArchiveFilterCondition.BuilderImpl> include) {
            this.include = ArchiveFilterConditionsCopier.copyFromBuilder(include);
        }

        @Override
        public final Builder include(Collection<ArchiveFilterCondition> include) {
            this.include = ArchiveFilterConditionsCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ArchiveFilterCondition ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(Consumer<ArchiveFilterCondition.Builder> ... include) {
            this.include(Stream.of(include).map(c -> (ArchiveFilterCondition)((ArchiveFilterCondition.Builder)ArchiveFilterCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ArchiveFilterCondition.Builder> getUnless() {
            List<ArchiveFilterCondition.Builder> result = ArchiveFilterConditionsCopier.copyToBuilder(this.unless);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnless(Collection<ArchiveFilterCondition.BuilderImpl> unless) {
            this.unless = ArchiveFilterConditionsCopier.copyFromBuilder(unless);
        }

        @Override
        public final Builder unless(Collection<ArchiveFilterCondition> unless) {
            this.unless = ArchiveFilterConditionsCopier.copy(unless);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(ArchiveFilterCondition ... unless) {
            this.unless(Arrays.asList(unless));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(Consumer<ArchiveFilterCondition.Builder> ... unless) {
            this.unless(Stream.of(unless).map(c -> (ArchiveFilterCondition)((ArchiveFilterCondition.Builder)ArchiveFilterCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ArchiveFilters build() {
            return new ArchiveFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveFilters> {
        public Builder include(Collection<ArchiveFilterCondition> var1);

        public Builder include(ArchiveFilterCondition ... var1);

        public Builder include(Consumer<ArchiveFilterCondition.Builder> ... var1);

        public Builder unless(Collection<ArchiveFilterCondition> var1);

        public Builder unless(ArchiveFilterCondition ... var1);

        public Builder unless(Consumer<ArchiveFilterCondition.Builder> ... var1);
    }
}

