/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.IngressIpOperator;
import software.amazon.awssdk.services.mailmanager.model.IngressIpv6ToEvaluate;
import software.amazon.awssdk.services.mailmanager.model.Ipv6CidrsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressIpv6Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressIpv6Expression> {
    private static final SdkField<IngressIpv6ToEvaluate> EVALUATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluate").getter(IngressIpv6Expression.getter(IngressIpv6Expression::evaluate)).setter(IngressIpv6Expression.setter(Builder::evaluate)).constructor(IngressIpv6ToEvaluate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(IngressIpv6Expression.getter(IngressIpv6Expression::operatorAsString)).setter(IngressIpv6Expression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(IngressIpv6Expression.getter(IngressIpv6Expression::values)).setter(IngressIpv6Expression.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD, OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressIpv6Expression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IngressIpv6ToEvaluate evaluate;
    private final String operator;
    private final List<String> values;

    private IngressIpv6Expression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final IngressIpv6ToEvaluate evaluate() {
        return this.evaluate;
    }

    public final IngressIpOperator operator() {
        return IngressIpOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressIpv6Expression)) {
            return false;
        }
        IngressIpv6Expression other = (IngressIpv6Expression)obj;
        return Objects.equals(this.evaluate(), other.evaluate()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"IngressIpv6Expression").add("Evaluate", (Object)this.evaluate()).add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluate": {
                return Optional.ofNullable(clazz.cast(this.evaluate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressIpv6Expression, T> g) {
        return obj -> g.apply((IngressIpv6Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IngressIpv6ToEvaluate evaluate;
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngressIpv6Expression model) {
            this.evaluate(model.evaluate);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final IngressIpv6ToEvaluate.Builder getEvaluate() {
            return this.evaluate != null ? this.evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressIpv6ToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressIpv6ToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressIpOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = Ipv6CidrsCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = Ipv6CidrsCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public IngressIpv6Expression build() {
            return new IngressIpv6Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressIpv6Expression> {
        public Builder evaluate(IngressIpv6ToEvaluate var1);

        default public Builder evaluate(Consumer<IngressIpv6ToEvaluate.Builder> evaluate) {
            return this.evaluate((IngressIpv6ToEvaluate)((IngressIpv6ToEvaluate.Builder)IngressIpv6ToEvaluate.builder().applyMutation(evaluate)).build());
        }

        public Builder operator(String var1);

        public Builder operator(IngressIpOperator var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

