/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddressList;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse;

public class ListAddressListsPublisher
implements SdkPublisher<ListAddressListsResponse> {
    private final MailManagerAsyncClient client;
    private final ListAddressListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAddressListsPublisher(MailManagerAsyncClient client, ListAddressListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAddressListsPublisher(MailManagerAsyncClient client, ListAddressListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAddressListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAddressListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddressList> addressLists() {
        Function<ListAddressListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addressLists() != null) {
                return response.addressLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAddressListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAddressListsResponseFetcher
    implements AsyncPageFetcher<ListAddressListsResponse> {
        private ListAddressListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddressListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAddressListsResponse> nextPage(ListAddressListsResponse previousPage) {
            if (previousPage == null) {
                return ListAddressListsPublisher.this.client.listAddressLists(ListAddressListsPublisher.this.firstRequest);
            }
            return ListAddressListsPublisher.this.client.listAddressLists((ListAddressListsRequest)((Object)ListAddressListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

