/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Archive
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Archive> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(Archive.getter(Archive::archiveId)).setter(Archive.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveName").getter(Archive.getter(Archive::archiveName)).setter(Archive.setter(Builder::archiveName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()}).build();
    private static final SdkField<String> ARCHIVE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveState").getter(Archive.getter(Archive::archiveStateAsString)).setter(Archive.setter(Builder::archiveState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveState").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(Archive.getter(Archive::lastUpdatedTimestamp)).setter(Archive.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD, ARCHIVE_NAME_FIELD, ARCHIVE_STATE_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Archive.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String archiveId;
    private final String archiveName;
    private final String archiveState;
    private final Instant lastUpdatedTimestamp;

    private Archive(BuilderImpl builder) {
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.archiveState = builder.archiveState;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final String archiveName() {
        return this.archiveName;
    }

    public final ArchiveState archiveState() {
        return ArchiveState.fromValue(this.archiveState);
    }

    public final String archiveStateAsString() {
        return this.archiveState;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)obj;
        return Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.archiveName(), other.archiveName()) && Objects.equals(this.archiveStateAsString(), other.archiveStateAsString()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Archive").add("ArchiveId", (Object)this.archiveId()).add("ArchiveName", (Object)this.archiveName()).add("ArchiveState", (Object)this.archiveStateAsString()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "ArchiveName": {
                return Optional.ofNullable(clazz.cast(this.archiveName()));
            }
            case "ArchiveState": {
                return Optional.ofNullable(clazz.cast(this.archiveStateAsString()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("ArchiveState", ARCHIVE_STATE_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Archive, T> g) {
        return obj -> g.apply((Archive)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String archiveId;
        private String archiveName;
        private String archiveState;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Archive model) {
            this.archiveId(model.archiveId);
            this.archiveName(model.archiveName);
            this.archiveState(model.archiveState);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return this.archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getArchiveState() {
            return this.archiveState;
        }

        public final void setArchiveState(String archiveState) {
            this.archiveState = archiveState;
        }

        @Override
        public final Builder archiveState(String archiveState) {
            this.archiveState = archiveState;
            return this;
        }

        @Override
        public final Builder archiveState(ArchiveState archiveState) {
            this.archiveState(archiveState == null ? null : archiveState.toString());
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public Archive build() {
            return new Archive(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Archive> {
        public Builder archiveId(String var1);

        public Builder archiveName(String var1);

        public Builder archiveState(String var1);

        public Builder archiveState(ArchiveState var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

